<?php
require 'conn/conn.php'; // Adjust path if needed

// ====================
// Dashboard Metrics
// ====================

// 1. Total Users
$stmt = $conn->prepare("SELECT COUNT(*) AS total_users FROM tbl_user");
$stmt->execute();
$totalUsers = $stmt->fetch(PDO::FETCH_ASSOC)['total_users'];

// 2. Total Appointments
$stmt = $conn->prepare("SELECT COUNT(*) AS total_appointments FROM appointments");
$stmt->execute();
$totalAppointments = $stmt->fetch(PDO::FETCH_ASSOC)['total_appointments'];

// 3. Total Feedbacks
$stmt = $conn->prepare("SELECT COUNT(*) AS total_feedbacks FROM feedback");
$stmt->execute();
$totalFeedbacks = $stmt->fetch(PDO::FETCH_ASSOC)['total_feedbacks'];

// 4. Total Mood Entries
$stmt = $conn->prepare("SELECT COUNT(*) AS total FROM daily_mood");
$stmt->execute();
$moodEntryCount = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// ====================
// Monthly User Registrations
// ====================
$stmt = $conn->prepare("
    SELECT MONTH(created_at) AS month, COUNT(*) AS count 
    FROM tbl_user 
    GROUP BY MONTH(created_at)
    ORDER BY MONTH(created_at)
");
$stmt->execute();
$monthlyData = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fill months with 0 initially
$monthlyCounts = array_fill(1, 12, 0);
foreach ($monthlyData as $row) {
    $monthlyCounts[(int)$row['month']] = (int)$row['count'];
}

// ====================
// Mood Distribution Data (for Pie Chart)
// ====================
$stmt = $conn->prepare("SELECT mood, COUNT(*) AS count FROM daily_mood GROUP BY mood");
$stmt->execute();
$moodData = $stmt->fetchAll(PDO::FETCH_ASSOC);

$labels = [];
$data = [];

foreach ($moodData as $row) {
    $labels[] = ucfirst($row['mood']); // Capitalize mood name
    $data[] = (int)$row['count'];
}

// ====================
// Latest Feedback (limit 10)
// ====================
$stmt = $conn->prepare("
    SELECT full_name, email, feedback_text, created_at 
    FROM feedback 
    ORDER BY created_at DESC 
    LIMIT 10
");
$stmt->execute();
$feedbacks = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>WellBeing | Admin Dashboard</title>

    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat&family=Ubuntu&display=swap"
        rel="stylesheet" />
    <link
        href="https://fonts.googleapis.com/css2?family=Satisfy&display=swap"
        rel="stylesheet" />

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet" />
    <link
        rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
        crossorigin="anonymous"
        referrerpolicy="no-referrer" />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">


    <!-- Bootstrap CSS -->
    <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
        rel="stylesheet" />
    <!-- Font Awesome -->
    <link
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
        rel="stylesheet" />


    <link rel="stylesheet" href="css/ManageCounselor.css" />
    <link rel="stylesheet" href="css/responsive.css" />


    <link rel="icon" href="images/logo.png" type="image/png">
</head>

<body>
    <!-- Sidebar -->
    <aside id="sidebar" aria-label="Sidebar Navigation">
        <div class="logo" aria-label="Logo">
            <img src="images/logo.png" alt="logo" class="logo-img" />
            <span class="logo-text"> WELLBEING </span>
        </div>
        <nav>
            <ul>
                <li>
                    <a href="#" class="active">
                        <i class="fas fa-tachometer-alt mr-2"></i>
                        <span class="text">Dashboard</span>
                    </a>
                </li>
                <li>
                    <a href="ManageCounselor.php" class="with-badge">
                        <i class="fas fa-hand-holding-medical mr-2"></i>
                        <span class="text"> Counselors</span>
                    </a>
                </li>
                <li>
                    <a href="admin.php" class="with-badge">
                        <i class="fas fa-users mr-2"></i>
                        <span class="text"> Manage User</span>
                    </a>
                </li>
                <li class="menu-item-collapsible">
                    <a href="javascript:void(0);" class="d-flex align-items-center justify-content-between submenu-toggle">
                        <span><i class="fas fa-layer-group mr-2"></i><span class="text"> Menu Levels</span></span>
                        <i class="fas fa-angle-right menu-arrow"></i>
                    </a>
                    <ul class="submenu list-unstyled">
                        <li><a href="#">Level 1</a></li>
                        <li><a href="#">Level 2</a></li>
                        <li><a href="#">Level 3</a></li>
                    </ul>
                </li>
            </ul>
        </nav>
    </aside>

    <!-- Top Navigation -->
    <header id="topnav" role="banner" aria-label="Top Navigation Bar">
        <div id="search-bar" aria-label="Site Search">
            <input type="search" aria-label="Search" placeholder="Search...">
            <i class="fas fa-search"></i>
        </div>

        <div class="nav-icons d-flex align-items-center">
            <i class="fas fa-bell me-3" aria-label="Notifications" title="Notifications" tabindex="0"></i>

            <!-- Logout Button -->
            <form action="index.php" method="POST" class="m-0">
                <button type="submit" class="btn btn-danger btn-sm" aria-label="Logout">
                    <i class="fas fa-sign-out-alt me-1 text-white"></i> Logout
                </button>
            </form>
        </div>
    </header>

    <main id="main-content" role="main">
        <section id="welcome-section" class="container-fluid px-5 py-4">
            <h3 class="mb-1">Hi, Welcome Admin</h3>
            <p class="text-muted">Let's manage the website!</p>
        </section>

        <!-- Dashboard Stats Section -->
        <section class="container-fluid px-5">
            <div class="row g-4">

                <!-- Total Users Card -->
                <div class="col-md-6 col-xl-3">
                    <div class="card shadow-sm border-0 rounded-4 p-3">
                        <div class="d-flex align-items-center">
                            <div class="bg-primary text-white rounded-circle d-flex justify-content-center align-items-center me-3" style="width: 60px; height: 60px;">
                                <i class="bi bi-people-fill fs-3"></i>
                            </div>
                            <div>
                                <h6 class="mb-0">Total Users</h6>
                                <h4 class="fw-bold"><?= htmlspecialchars($totalUsers) ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Appointments Card -->
                <div class="col-md-6 col-xl-3">
                    <div class="card shadow-sm border-0 rounded-4 p-3">
                        <div class="d-flex align-items-center">
                            <div class="bg-success text-white rounded-circle d-flex justify-content-center align-items-center me-3" style="width: 60px; height: 60px;">
                                <i class="bi bi-calendar-check-fill fs-3"></i>
                            </div>
                            <div>
                                <h6 class="mb-0">Appointments</h6>
                                <h4 class="fw-bold"><?= htmlspecialchars($totalAppointments) ?></h4>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Feedbacks -->
                <div class="col-md-6 col-xl-3">
                    <div class="card shadow-sm border-0 rounded-4 p-3">
                        <div class="d-flex align-items-center">
                            <div class="bg-warning text-white rounded-circle d-flex justify-content-center align-items-center me-3" style="width: 60px; height: 60px;">
                                <i class="bi bi-chat-left-dots-fill fs-3"></i>
                            </div>
                            <div>
                                <h6 class="mb-0">Feedbacks</h6>
                                <h4 class="fw-bold"><?= htmlspecialchars($totalFeedbacks) ?></h4>
                            </div>
                        </div>
                    </div>
                </div>


                <!-- Mood Entries -->
                <div class="col-md-6 col-xl-3">
                    <div class="card shadow-sm border-0 rounded-4 p-3">
                        <div class="d-flex align-items-center">
                            <div class="bg-danger text-white rounded-circle d-flex justify-content-center align-items-center me-3" style="width: 60px; height: 60px;">
                                <i class="bi bi-emoji-smile-fill fs-3"></i>
                            </div>
                            <div>
                                <h6 class="mb-0">Mood Entries</h6>
                                <h4 class="fw-bold"><?= htmlspecialchars($moodEntryCount) ?></h4>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </section>

        <section class="container-fluid px-5 mt-4">
            <div class="row">
                <!-- Bar Chart -->
                <div class="col-md-6 mb-4">
                    <div class="card shadow-sm border-0 rounded-4 p-4" style="height: 440px;">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h5>User Registrations (Monthly)</h5>
                            <button id="toggleBtn" class="btn btn-outline-primary rounded-pill px-4 py-2 shadow-sm">
                                Show Jul–Dec
                            </button>
                        </div>
                        <div style="height: 300px;">
                            <canvas id="barChart"></canvas>
                        </div>
                    </div>
                </div>

                <!-- Pie Chart -->
                <div class="col-md-6 mb-4">
                    <div class="card shadow-sm border-0 rounded-4 p-4" style="height: 440px;">
                        <h5 class="mb-3">Mood Distribution</h5>
                        <div style="height: 300px;">
                            <canvas id="pieChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <section class="container-fluid px-5 mt-4">
            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-body p-4">
                    <h5 class="mb-4">
                        <i class="bi bi-chat-dots fs-3 text-primary me-4"></i>Recent Feedback from Users
                    </h5>

                    <div class="feedback-list" style="max-height: 320px; overflow-y: auto;">
                        <?php if (!empty($feedbacks)): ?>
                            <?php foreach ($feedbacks as $index => $fb): ?>
                                <div class="d-flex mb-4 pb-3 border-bottom">
                                    <div class="me-3">
                                        <div class="bg-<?= ['primary', 'success', 'warning', 'info', 'danger'][$index % 5] ?> text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                            <i class="bi bi-person-circle fs-4"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">
                                            <?= htmlspecialchars($fb['full_name']) ?>
                                            <small class="text-muted">– <?= date('F j, Y', strtotime($fb['created_at'])) ?></small>
                                        </h6>
                                        <p class="mb-0 text-muted">
                                            <i class="bi bi-envelope-fill me-1"></i><?= htmlspecialchars($fb['email']) ?>
                                        </p>
                                        <p class="mb-0 text-muted"><?= htmlspecialchars($fb['feedback_text']) ?></p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <p class="text-muted">No feedback available yet.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>

    </main>



    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // Inject PHP data for Pie Chart before using them
        const moodLabels = <?= json_encode($labels) ?>;
        const moodCounts = <?= json_encode($data) ?>;

        const monthlyUserCounts = <?= json_encode(array_values($monthlyCounts)) ?>;
        const labels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

        let showingFirstHalf = true;

        const barCtx = document.getElementById('barChart').getContext('2d');
        const barChart = new Chart(barCtx, {
            type: 'bar',
            data: {
                labels: labels.slice(0, 6),
                datasets: [{
                    label: 'Users',
                    data: monthlyUserCounts.slice(0, 6),
                    backgroundColor: [
                        '#4e73df', '#1cc88a', '#36b9cc',
                        '#f6c23e', '#e74a3b', '#858796'
                    ],
                    borderRadius: 8,
                    hoverBackgroundColor: '#343a40'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        backgroundColor: '#fff',
                        titleColor: '#333',
                        bodyColor: '#666',
                        borderColor: '#ccc',
                        borderWidth: 1
                    }
                },
                scales: {
                    x: {
                        grid: {
                            display: false
                        },
                        ticks: {
                            font: {
                                size: 14
                            }
                        }
                    },
                    y: {
                        beginAtZero: true,
                        ticks: {
                            font: {
                                size: 14
                            }
                        }
                    }
                }
            }
        });

        // Toggle logic for Bar Chart
        document.getElementById('toggleBtn').addEventListener('click', () => {
            if (showingFirstHalf) {
                barChart.data.labels = labels.slice(6);
                barChart.data.datasets[0].data = monthlyUserCounts.slice(6);
                barChart.data.datasets[0].backgroundColor = [
                    '#20c997', '#fd7e14', '#6f42c1',
                    '#0dcaf0', '#6610f2', '#198754'
                ];
                document.getElementById('toggleBtn').textContent = 'Show Jan–Jun';
            } else {
                barChart.data.labels = labels.slice(0, 6);
                barChart.data.datasets[0].data = monthlyUserCounts.slice(0, 6);
                barChart.data.datasets[0].backgroundColor = [
                    '#4e73df', '#1cc88a', '#36b9cc',
                    '#f6c23e', '#e74a3b', '#858796'
                ];
                document.getElementById('toggleBtn').textContent = 'Show Jul–Dec';
            }
            barChart.update();
            showingFirstHalf = !showingFirstHalf;
        });

        // Pie Chart (Mood Distribution)
        const pieCtx = document.getElementById('pieChart').getContext('2d');
        const pieChart = new Chart(pieCtx, {
            type: 'doughnut',
            data: {
                labels: moodLabels,
                datasets: [{
                    data: moodCounts,
                    backgroundColor: ['#1cc88a', '#e74a3b', '#f6c23e', '#36b9cc', '#6f42c1', '#0dcaf0'],
                    hoverOffset: 10,
                    borderColor: '#fff',
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            font: {
                                size: 14
                            }
                        }
                    },
                    tooltip: {
                        backgroundColor: '#fff',
                        titleColor: '#333',
                        bodyColor: '#666',
                        borderColor: '#ccc',
                        borderWidth: 1
                    }
                }
            }
        });
    </script>


</body>

</html>