<?php
session_start();
include('conn/conn.php'); // update path if necessary

// Counselor cancels session
if (isset($_POST['cancel_session_id'])) {
    $session_id = $_POST['cancel_session_id'];
    $counselor_name = $_SESSION['counselor_name'];

    // Fix: use session_id instead of id
    $stmt = $conn->prepare("DELETE FROM sessions WHERE session_id = ? AND counselor_name = ?");
    $stmt->execute([$session_id, $counselor_name]);

    echo "<script>alert('Session canceled successfully.'); window.location.href='CreateSession.php';</script>";
    exit();
}

// Counselor creates session link
if (isset($_POST['create_session'])) {
    $counselor_name = $_SESSION['counselor_name'];
    $time_slot = $_POST['time_slot'];
    $meeting_link = $_POST['meeting_link'];

    $stmt = $conn->prepare("INSERT INTO sessions (counselor_name, time_slot, meeting_link) VALUES (?, ?, ?)");
    $stmt->execute([$counselor_name, $time_slot, $meeting_link]);

    echo "<script>alert('Session link created successfully!'); window.location.href='CreateSession.php';</script>";
    exit();
}

?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>WellBeing | Create Sessions</title>

    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat&family=Ubuntu&display=swap"
        rel="stylesheet" />
    <link
        href="https://fonts.googleapis.com/css2?family=Satisfy&display=swap"
        rel="stylesheet" />

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet" />
    <link
        rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
        crossorigin="anonymous"
        referrerpolicy="no-referrer" />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <!-- Bootstrap CSS -->
    <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
        rel="stylesheet" />
    <!-- Font Awesome -->
    <link
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
        rel="stylesheet" />

    <link rel="stylesheet" href="css/CounselorDashboard.css" />
    <link rel="stylesheet" href="css/responsive.css" />
    <link rel="icon" href="images/logo.png" type="image/png">
</head>

<body>
    <!-- Sidebar -->
    <aside id="sidebar" aria-label="Sidebar Navigation">
        <div class="logo" aria-label="Logo">
            <img src="images/logo.png" alt="logo" class="logo-img">
            <span class="logo-text"> WELLBEING </span>
        </div>
        <nav>
            <ul>
                <li>
                    <a href="CounselorFront.php" class="with-badge">
                        <i class="fas fa-th-large mr-2"></i>
                        <span class="text">Dashboard</span>
                    </a>
                </li>
                <li>
                    <a href="CounselorDashboard.php" class="with-badge">
                        <i class="fas fa-calendar-check mr-2"></i>
                        <span class="text"> Manage Appointment</span>
                    </a>
                </li>
                <li>
                    <a href="#" class="with-active">
                        <i class="fas fa-video mr-2"></i>
                        <span class="text"> Create Sessions</span>
                    </a>
                </li>
                <li>
                    <a href="ManageResources.php" class="with-badge">
                        <i class="fas fa-folder-open mr-2"></i>
                        <span class="text"> Manage Resources</span>
                    </a>
                </li>
                <li class="menu-item-collapsible">
                    <a
                        href="javascript:void(0);"
                        class="d-flex align-items-center justify-content-between submenu-toggle">
                        <span><i class="fas fa-layer-group mr-2"></i><span class="text"> Menu Levels</span></span>
                        <i class="fas fa-angle-right menu-arrow"></i>
                    </a>
                    <ul class="submenu list-unstyled">
                        <li><a href="#">Level 1</a></li>
                        <li><a href="#">Level 2</a></li>
                        <li><a href="#">Level 3</a></li>
                    </ul>
                </li>
            </ul>
        </nav>
    </aside>

    <!-- Top Navigation -->
    <header id="topnav" role="banner" aria-label="Top Navigation Bar">
        <div id="search-bar" aria-label="Site Search">
            <input type="search" aria-label="Search" placeholder="Search..." />
            <i class="fas fa-search"></i>
        </div>

        <div class="nav-icons">
            <i class="fas fa-bell" aria-label="Notifications" title="Notifications" tabindex="0" onclick="window.open('https://dashboard.tawk.to/#/chat', '_blank')" style="cursor: pointer;"></i>
            <div class="user-profile" tabindex="0" aria-label="User Profile">
                <span class="greeting">Hi, <?= htmlspecialchars($_SESSION['counselor_name'] ?? 'Guest') ?></span>
                <img src="<?= htmlspecialchars($_SESSION['counselor_image']) ?>" alt="User Profile Picture" style="width:40px; height:40px; object-fit:cover;" class="rounded-circle" />
            </div>
        </div>
    </header>

    <main id="main-content" role="main">
        <!-- view section -->
        <section class="container-fluid px-5 mt-5">
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h5>Your Created Sessions</h5>
                </div>
                <div class="card-body">
                    <table class="table table-striped table-bordered mb-0">
                        <thead>
                            <tr>
                                <th>Time Slot</th>
                                <th>Meeting Link</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counselor_name = $_SESSION['counselor_name'];
                            $stmt = $conn->prepare("SELECT * FROM sessions WHERE counselor_name = ? ORDER BY time_slot DESC");
                            $stmt->execute([$counselor_name]);
                            $sessions = $stmt->fetchAll();

                            if (count($sessions) > 0):
                                foreach ($sessions as $session):
                            ?>
                                    <tr>
                                        <td><?= date("M d, Y - h:i A", strtotime($session['time_slot'])) ?></td>
                                        <td><a href="<?= htmlspecialchars($session['meeting_link']) ?>" target="_blank">Join Link</a></td>
                                        <td>
                                            <form method="POST" action="CreateSession.php" onsubmit="return confirm('Are you sure you want to cancel this session?');" class="d-inline">
                                                <input type="hidden" name="cancel_session_id" value="<?= $session['session_id'] ?>">
                                                <button type="submit" class="btn btn-danger btn-sm">Cancel</button>
                                            </form>
                                        </td>
                                    </tr>
                            <?php
                                endforeach;
                            else:
                                echo "<tr><td colspan='3' class='text-center'>No sessions created yet.</td></tr>";
                            endif;
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>

        <!-- create session link -->
        <section id="session-link-section" class="container-fluid px-5 mt-5">
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h5>Create a New Session</h5>
                </div>
                <div class="card-body">
                    <div class="quote-card p-3 mb-4" style="border-left: 5px solid #007bff; background: #f8f9fa;">
                        <p class="mb-0" style="font-size: 1.1rem;">Use the form below to create a session with a meeting link and time.</p>
                    </div>

                    <form method="POST">
                        <div class="form-group mb-3">
                            <label for="time_slot">Time Slot</label>
                            <input type="datetime-local" name="time_slot" id="time_slot" class="form-control" required>
                        </div>
                        <div class="form-group mb-3">
                            <label for="meeting_link">Meeting Link</label>
                            <input type="url" name="meeting_link" id="meeting_link" class="form-control" placeholder="https://meet.example.com/session" required>
                        </div>
                        <button type="submit" name="create_session" class="btn btn-primary">Create Session</button>
                    </form>
                </div>
            </div>
        </section>
    </main>
</body>

</html>