<?php
session_start();
include 'conn/conn.php';
if (isset($_POST['add_counselor'])) {
    $name = $_POST['counselor_name'];
    $password = $_POST['counselor_password'];
    $email = $_POST['counselor_email'];
    $phone = $_POST['counselor_phone'];
    $specialization = $_POST['counselor_specialization'];

    // Handle profile image upload
    $imageFileName = null;
    if (!empty($_FILES['profile_image']['name'])) {
        $targetDir = "uploads/";
        $imageFileName = time() . '_' . basename($_FILES["profile_image"]["name"]);
        $targetFilePath = $targetDir . $imageFileName;

        // Ensure uploads/ directory exists
        if (!is_dir($targetDir)) {
            mkdir($targetDir, 0755, true);
        }

        move_uploaded_file($_FILES["profile_image"]["tmp_name"], $targetFilePath);
    }

    // Insert including profile_image
    $stmt = $conn->prepare("INSERT INTO counselors (name, CounselorPassword, email, phone, specialization, profile_image) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->execute([$name, $password, $email, $phone, $specialization, $imageFileName]);

    echo "<script>alert('Counselor registration successful.'); window.location='ManageCounselor.php';</script>";
    exit();
}


?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>WellBeing | Manage Counselors</title>

    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat&family=Ubuntu&display=swap"
        rel="stylesheet" />
    <link
        href="https://fonts.googleapis.com/css2?family=Satisfy&display=swap"
        rel="stylesheet" />

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet" />
    <link
        rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
        crossorigin="anonymous"
        referrerpolicy="no-referrer" />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <!-- Bootstrap CSS -->
    <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
        rel="stylesheet" />
    <!-- Font Awesome -->
    <link
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
        rel="stylesheet" />


    <link rel="stylesheet" href="css/ManageCounselor.css" />
    <link rel="stylesheet" href="css/responsive.css" />


    <link rel="icon" href="images/logo.png" type="image/png">
</head>

<body>
    <!-- Sidebar -->
    <aside id="sidebar" aria-label="Sidebar Navigation">
        <div class="logo" aria-label="Logo">
            <img src="images/logo.png" alt="logo" class="logo-img" />
            <span class="logo-text"> WELLBEING </span>
        </div>
        <nav>
            <ul>
                <li>
                    <a href="AdminDashboard.php" class="with-badge">
                        <i class="fas fa-tachometer-alt mr-2"></i>
                        <span class="text">Dashboard</span>
                    </a>
                </li>
                <li>
                    <a href="#" class="active">
                        <i class="fas fa-hand-holding-medical mr-2"></i>
                        <span class="text"> Counselors</span>
                    </a>
                </li>
                <li>
                    <a href="admin.php" class="with-badge">
                        <i class="fas fa-users mr-2"></i>
                        <span class="text"> Manage User</span>
                    </a>
                </li>
                <li class="menu-item-collapsible">
                    <a href="javascript:void(0);" class="d-flex align-items-center justify-content-between submenu-toggle">
                        <span><i class="fas fa-layer-group mr-2"></i><span class="text"> Menu Levels</span></span>
                        <i class="fas fa-angle-right menu-arrow"></i>
                    </a>
                    <ul class="submenu list-unstyled">
                        <li><a href="#">Level 1</a></li>
                        <li><a href="#">Level 2</a></li>
                        <li><a href="#">Level 3</a></li>
                    </ul>
                </li>
            </ul>
        </nav>
    </aside>

    <!-- Top Navigation -->
    <header id="topnav" role="banner" aria-label="Top Navigation Bar">
        <div id="search-bar" aria-label="Site Search">
            <input type="search" aria-label="Search" placeholder="Search..." />
            <i class="fas fa-search"></i>
        </div>
        <div class="nav-icons">
            <i class="fas fa-bell" aria-label="Notifications" title="Notifications" tabindex="0"></i>
            <div class="user-profile" tabindex="0" aria-label="User Profile">
                <span class="greeting">Hi, Syazwi</span>
                <img src="images/awi .jpg" alt="User Profile Picture" />
            </div>
        </div>
    </header>

    <main id="main-content" role="main">
        <!-- view section -->
        <section class="container-fluid px-5 mt-5">
            <div class="card shadow">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">List of Counselors</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3 d-flex justify-content-between align-items-center">
                        <input type="search" id="searchCounselor" class="form-control w-50" placeholder="Insert Counselor Name..." aria-label="Search Counselor" />
                        <button class="btn btn-success ms-3" onclick="openRegisterModal()">Register Counselor</button>
                    </div>

                    <table id="counselorTable" class="table table-bordered table-striped">
                        <thead class="table-secondary">
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Password</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Specialization</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $stmt = $conn->prepare("SELECT * FROM counselors");
                            $stmt->execute();
                            $counselors = $stmt->fetchAll();

                            foreach ($counselors as $row):
                                $id = $row['id'];
                            ?>
                                <tr>
                                    <td id="id-<?= $id ?>"><?= $id ?></td>
                                    <td id="name-<?= $id ?>"><?= htmlspecialchars($row['name']) ?></td>
                                    <td id="password-<?= $id ?>"><?= htmlspecialchars($row['CounselorPassword']) ?></td>
                                    <td id="email-<?= $id ?>"><?= htmlspecialchars($row['email']) ?></td>
                                    <td id="phone-<?= $id ?>"><?= htmlspecialchars($row['phone']) ?></td>
                                    <td id="specialization-<?= $id ?>"><?= htmlspecialchars($row['specialization']) ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-primary" onclick="update_counselor(<?= $id ?>)" aria-label="Edit Counselor <?= htmlspecialchars($row['name']) ?>">✏️</button>
                                        <button class="btn btn-sm btn-danger" onclick="delete_counselor(<?= $id ?>)" aria-label="Delete Counselor <?= htmlspecialchars($row['name']) ?>">🗑️</button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>

        <!-- Update Counselor Modal -->
        <div class="modal fade mt-5" id="updateCounselorModal" tabindex="-1" role="dialog" aria-labelledby="updateCounselorModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <form action="./endpoint/update-counselor.php" method="POST" enctype="multipart/form-data">
                        <div class="modal-header">
                            <h5 class="modal-title" id="updateCounselorModalLabel">Update Counselor</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" name="id" id="updateCounselorID" />
                            <div class="form-group">
                                <label for="updateName">Name:</label>
                                <input type="text" class="form-control" id="updateName" name="name" required />
                            </div>
                            <div class="form-group">
                                <label for="updateCounselorPassword">Password:</label>
                                <input type="password" class="form-control" id="updateCounselorPassword" name="CounselorPassword" placeholder="Leave blank to keep current password" />
                            </div>
                            <div class="form-group">
                                <label for="updateEmail">Email:</label>
                                <input type="email" class="form-control" id="updateEmail" name="email" required />
                            </div>
                            <div class="form-group">
                                <label for="updatePhone">Phone:</label>
                                <input type="tel" class="form-control" id="updatePhone" name="phone" required />
                            </div>
                            <div class="form-group">
                                <label for="updateSpecialization">Specialization:</label>
                                <input type="text" class="form-control" id="updateSpecialization" name="specialization" required />
                            </div>
                            <div class="form-group">
                                <label for="updateProfileImage">Profile Image:</label>
                                <input type="file" class="form-control" id="updateProfileImage" name="profile_image" accept="image/*">
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-dark form-control">Update Counselor</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Admin Register Counselor -->
        <div id="register-modal" class="register-modal">
            <section class="register-modal-card">
                <div class="cross-icon" onclick="closeRegisterModal()">
                    <i class="fa fa-times"></i>
                </div>
                <form method="post" enctype="multipart/form-data">
                    <input type="hidden" name="add_counselor" value="1">
                    <h1>Register Counselors</h1>
                    <label>Name:</label>
                    <input type="text" name="counselor_name" required>
                    <label>Password:</label>
                    <input type="password" name="counselor_password" required>
                    <label>Email:</label>
                    <input type="email" name="counselor_email" required>
                    <label>Phone:</label>
                    <input type="text" name="counselor_phone" required>
                    <label>Specialization:</label>
                    <label>Profile Image:</label>
                    <input type="file" name="profile_image" accept="image/*">
                    <input type="text" name="counselor_specialization" required>
                    <button type="submit">Add Counselor</button>
                </form>
            </section>
        </div>
    </main>

    <!-- Include jQuery and Bootstrap JS for modal and other functionality -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Show update modal and fill data from the table cells
        function update_counselor(id) {
            // Get data from table cells by id
            const name = $("#name-" + id).text();
            const password = $("#password-" + id).text();
            const email = $("#email-" + id).text();
            const phone = $("#phone-" + id).text();
            const specialization = $("#specialization-" + id).text();

            $("#updateCounselorID").val(id);
            $("#updateName").val(name);
            $("#updateCounselorPassword").val(''); // blank by default, so password stays unchanged if empty
            $("#updateEmail").val(email);
            $("#updatePhone").val(phone);
            $("#updateSpecialization").val(specialization);

            $("#updateCounselorModal").modal("show");
        }


        function openRegisterModal() {
            document.getElementById("register-modal").style.display = "flex";
        }

        function closeRegisterModal() {
            document.getElementById("register-modal").style.display = "none";
        }

        // Delete confirmation
        function delete_counselor(id) {
            if (confirm("Are you sure you want to delete this counselor?")) {
                window.location.href = "ManageCounselor.php?delete_counselor=" + id;
            }
        }
    </script>


    <script>
        // Listen for input changes on the search box
        document.getElementById('searchCounselor').addEventListener('input', function() {
            const filter = this.value.toLowerCase();
            const rows = document.querySelectorAll('#counselorTable tbody tr');

            rows.forEach(row => {
                // Get the counselor's name text
                const nameCell = row.querySelector('td:nth-child(2)');
                if (nameCell) {
                    const nameText = nameCell.textContent.toLowerCase();
                    // Show row if name includes the search term, else hide
                    if (nameText.includes(filter)) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                }
            });
        });
    </script>

</body>

</html>