<?php
session_start();
include('conn/conn.php'); // Ensure this connects to your DB

// Redirect if not logged in
if (!isset($_SESSION['email'])) {
    header("Location: index.php");
    exit();
}

$latest_mood = !empty($mood_results) ? $mood_results[0] : null;

$student_email = $_SESSION['email'];

// Fetch user full name based on email
$userStmt = $conn->prepare("SELECT first_name, last_name FROM tbl_user WHERE email = :email");
$userStmt->bindParam(':email', $student_email, PDO::PARAM_STR);
$userStmt->execute();
$user = $userStmt->fetch();

$student_name = $user['first_name'] . ' ' . $user['last_name'];

// Fetch the latest quote from tbl_quote table
$quoteQuery = $conn->query("SELECT * FROM tbl_quote ORDER BY id DESC LIMIT 1");
$quote = $quoteQuery->fetch();

// Get appointment count for the logged-in user
$appointmentStmt = $conn->prepare("SELECT COUNT(*) FROM appointments WHERE student_name = :student_name AND status = 'Approved'");
$appointmentStmt->bindParam(':student_name', $student_name, PDO::PARAM_STR);
$appointmentStmt->execute();
$appointment_count = $appointmentStmt->fetchColumn();


// Get total session count
$sessionStmt = $conn->prepare("SELECT COUNT(*) FROM sessions");
$sessionStmt->execute();
$session_count = $sessionStmt->fetchColumn();

// Fetch past mood quiz results for this user
$moodStmt = $conn->prepare("SELECT score, mood, suggestion, created_at FROM quiz_results WHERE email = :email ORDER BY created_at DESC LIMIT 3");
$moodStmt->bindParam(':email', $student_email, PDO::PARAM_STR);
$moodStmt->execute();
$mood_results = $moodStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch the latest mood for the logged-in user
$email = $_SESSION['email']; // ✅ Assign email from session

$stmt = $conn->prepare("SELECT mood, suggestion FROM quiz_results WHERE email = :email ORDER BY created_at DESC LIMIT 1");
$stmt->execute(['email' => $email]);
$latest_mood = $stmt->fetch(PDO::FETCH_ASSOC);

try {
    // Fetch all user data
    $stmt = $conn->prepare("SELECT * FROM tbl_user WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        // Invalid session or user deleted
        session_destroy();
        header("Location: index.php");
        exit();
    }

    // Determine image path
    $imagePath = (!empty($user['profile_image']) && file_exists("uploads/" . $user['profile_image']))
        ? "uploads/" . $user['profile_image']
        : "images/default-profile.jpg";
} catch (PDOException $e) {
    echo "Database error: " . $e->getMessage();
    exit();
}
?>






<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>WellBeing | Student Dashboard</title>

    <link href="https://fonts.googleapis.com/css2?family=Montserrat&family=Ubuntu&display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Satisfy&display=swap" rel="stylesheet" />

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet" />

    <link rel="stylesheet" href="css/UserDashboard.css" />
    <link rel="stylesheet" href="css/Responsive.css" />
    <link rel="icon" href="images/logo.png" type="image/png">
</head>

<body>

    <!-- Sidebar -->
    <aside id="sidebar" aria-label="Sidebar Navigation">
        <div class="logo" aria-label="Logo">
            <img src="images/logo.png" alt="logo" class="logo-img">
            <span class="logo-text"> WELLBEING </span>
        </div>
        <nav>
            <ul>
                <li>
                    <a href="#" class="active">
                        <i class="fas fa-tachometer-alt mr-2"></i> <span class="text">Dashboard</span>
                    </a>
                </li>
                <li>
                    <a href="Resources.php" class="with-badge">
                        <i class="fas fa-th-large mr-2"></i>
                        <span class="text"> Resources</span>
                    </a>
                </li>
                <li>
                    <a href="appointment.php" class="with-badge">
                        <i class="fas fa-book mr-2"></i>
                        <span class="text"> Appointment</span>
                    </a>

                </li>
                <li>
                    <a href="session.php" class="with-badge">
                        <i class="fas fa-calendar-check mr-2"></i>
                        <span class="text"> Session</span>
                    </a>

                </li>
                <li>
                    <a href="Forum.php" class="with-badge">
                        <i class="fas fa-comments mr-2"></i>
                        <span class="text"> Student Space</span>
                    </a>

                </li>
                <li>
                    <a href="UserProfile.php" class="with-badge">
                        <i class="fas fa-edit mr-2"></i>
                        <span class="text"> Profile</span>
                    </a>

                </li>
                <li class="menu-item-collapsible">
                    <a href="javascript:void(0);" class="d-flex align-items-center justify-content-between submenu-toggle">
                        <span><i class="fas fa-layer-group mr-2"></i><span class="text"> Menu Levels</span></span>
                        <i class="fas fa-angle-right menu-arrow"></i>
                    </a>
                    <ul class="submenu list-unstyled">
                        <li><a href="#">Level 1</a></li>
                        <li><a href="#">Level 2</a></li>
                        <li><a href="#">Level 3</a></li>
                    </ul>
                </li>
            </ul>

        </nav>
    </aside>

    <!-- Top Navigation -->
    <header id="topnav" role="banner" aria-label="Top Navigation Bar">
        <div id="search-bar">
            <input type="search" placeholder="Search..." />
            <i class="fas fa-search"></i>
        </div>
        <div class="nav-icons">
            <a href="index.php" title="Logout" aria-label="Logout">
                <i class="fas fa-sign-out-alt" tabindex="0"></i>
            </a>

            <div class="user-profile" tabindex="0" aria-label="User Profile">
                <span class="greeting">Hi, <?= htmlspecialchars($user['first_name']) ?></span>
                <a href="UserProfile.php">
                    <img src="<?= htmlspecialchars($imagePath) ?>" alt="User Profile Picture"
                        class="rounded-circle" style="width: 40px; height: 40px; object-fit: cover;">
                </a>
            </div>

        </div>
    </header>



    <!-- Main Content -->
    <main id="main-content" role="main">
        <section id="welcome-section">
            <h2>Hi, Welcome <?php echo htmlspecialchars($student_name); ?></h2>
            <p>Manage Your Mental Health Here!</p>
        </section>


        <div id="main-grid">
            <section id="left-content">


                <div class="button-row" aria-label="Dashboard Buttons">
                    <button id="mood-button" class="metric-button btn-blue shadow" type="button" aria-label="Mood <?= htmlspecialchars($latestMood) ?> Button">
                        😊 Mood: <?= htmlspecialchars($latestMood) ?>
                    </button>

                    <button class="metric-button btn-danger shadow" type="button" onclick="window.location.href='appointment.php';">
                        📅 Appointment: <?= htmlspecialchars($appointment_count) ?>
                    </button>



                    <button class="metric-button btn-green shadow" type="button">
                        🧑‍⚕️ Session: <?= htmlspecialchars($session_count) ?>
                    </button>
                </div>







                <section id="stats-mood" aria-label="User Statistics Mood">
                    <div class="header d-flex justify-content-between align-items-center mb-3">
                        <h3>Monthly Statistics Mood</h3>
                        <div class="btn-group" role="group" aria-label="Export and Print buttons">
                            <button type="button" class="btn btn-outline-primary btn-sm" id="exportChartBtn" title="Export">
                                <i class="fas fa-file-export"></i> Export
                            </button>
                            <button type="button" class="btn btn-outline-secondary btn-sm" id="printChartBtn" title="Print">
                                <i class="fas fa-print"></i> Print
                            </button>
                        </div>
                    </div>



                    <div class="chart-card-container">
                        <div class="card graph">
                            <div class="graph-body">
                                <!-- Mood History Display -->
                                <div class="history">
                                    <ul id="mood-history"></ul>
                                </div>
                                <!-- Chart Section -->
                                <div class="chart-wrapper">
                                    <canvas id="mood-chart" width="400" height="180"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="container my-2">
                    <div class="card mood-card shadow rounded-4">
                        <div class="card-body p-4">
                            <h4 class="text-center mb-4">Mood Tracker</h4>

                            <!-- Mood Buttons -->
                            <div class="d-flex justify-content-center flex-wrap mb-3">
                                <button class="btn btn-outline-secondary mood-btn" onclick="selectMood(this)" data-mood="Happy">😊</button>
                                <button class="btn btn-outline-secondary mood-btn" onclick="selectMood(this)" data-mood="Sad">😢</button>
                                <button class="btn btn-outline-secondary mood-btn" onclick="selectMood(this)" data-mood="Angry">😠</button>
                                <button class="btn btn-outline-secondary mood-btn" onclick="selectMood(this)" data-mood="Stressed">😩</button>
                                <button class="btn btn-outline-secondary mood-btn" onclick="selectMood(this)" data-mood="Neutral">😐</button>
                            </div>

                            <!-- Note Textarea -->
                            <div class="mb-3">
                                <label for="moodNote" class="form-label">Write about your mood (optional)</label>
                                <textarea class="form-control note-box" id="moodNote" rows="3" placeholder="E.g., I feel tired because..."></textarea>
                            </div>

                            <!-- Submit Button -->
                            <div class="text-center">
                                <button class="btn btn-primary px-4" onclick="submitMood()">Submit</button>
                            </div>
                        </div>
                    </div>
                </section>


                <section>
                    <div class="container mt-5">
                        <div class="table-responsive rounded-4 shadow" style="overflow: hidden; border-radius: 20px; border: 1px solid #cce0ff;">
                            <table class="table table-borderless align-middle text-center mb-0">
                                <thead class="text-white fs-5" style="background: linear-gradient(90deg,rgb(235, 4, 204),rgb(150, 25, 123));">
                                    <tr>
                                        <th class="py-3">📊 Score</th>
                                        <th class="py-3">💬 Mood</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white">
                                    <?php if (!empty($mood_results)): ?>
                                        <?php foreach ($mood_results as $row): ?>
                                            <tr class="border-top">
                                                <td class="fw-bold text-primary fs-4 py-3">
                                                    <?= $row['score'] ?>
                                                </td>
                                                <td class="py-3">
                                                    <?php
                                                    $mood = strtolower($row['mood']);
                                                    $emoji = '';
                                                    $badgeClass = '';

                                                    switch ($mood) {
                                                        case 'happy':
                                                            $emoji = '😊';
                                                            $badgeClass = 'bg-success';
                                                            break;
                                                        case 'anxious':
                                                            $emoji = '😰';
                                                            $badgeClass = 'bg-warning text-dark';
                                                            break;
                                                        case 'stressed':
                                                            $emoji = '😣';
                                                            $badgeClass = 'bg-info text-dark';
                                                            break;
                                                        case 'overwhelmed':
                                                            $emoji = '😫';
                                                            $badgeClass = 'bg-danger';
                                                            break;
                                                        default:
                                                            $emoji = '😐';
                                                            $badgeClass = 'bg-secondary';
                                                    }
                                                    ?>
                                                    <span class="badge <?= $badgeClass ?> fs-5 px-4 py-2 rounded-pill shadow-sm">
                                                        <?= $emoji ?> <?= ucfirst($mood) ?>
                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="2" class="text-muted fs-6 py-4">No mood records available yet.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>
            </section>



            <section id="right-cards" aria-label="Right Cards Section">
                <article class="daily-sales-card" aria-labelledby="daily-sales-title daily-sales-date daily-sales-value">
                    <h4 id="daily-sales-title" class="tittle-quiz text-center">Mental Health</h4>
                    <div class="suggestion-div">
                        <h2>Suggestions</h2>
                        <p>
                            Your journey towards better mental health starts here. Take the quiz to unlock personalized mood analysis and meditation tips!
                        </p>
                        <div id="result" class="result">
                            <div>
                                <h2>Your Mood Analysis</h2>
                                <p id="moodAnalysis"><?= $latest_mood ? htmlspecialchars($latest_mood['mood']) : 'None' ?></p>
                            </div>
                            <div>
                                <h2>Suggested Meditation</h2>
                                <p id="meditationSuggestion"><?= $latest_mood ? htmlspecialchars($latest_mood['suggestion']) : 'None' ?></p>
                                <div class="quiz-button-div">
                                    <button onclick="openModal()">Start Your Quiz</button>
                                </div>
                            </div>
                        </div>


                    </div>
                </article>
                <div>
                    <div class="quote-card">
                        <h2>Quote Of The Day!</h2>
                        <blockquote>
                            “<?= htmlspecialchars($quote['quote_text']) ?>”
                        </blockquote>
                        <cite>— <?= htmlspecialchars($quote['quote_author']) ?></cite>
                    </div>
                </div>
                <div class="card shadow-sm p-4 rounded-4 bg-light border-0">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-emoji-smile text-primary fs-4 me-2"></i>
                            <div>
                                <h5 class="mb-0 fw-semibold text-primary">Mood Streak Tracker</h5>
                                <small class="text-muted">Consistency matters, keep it going!</small>
                            </div>
                        </div>
                    </div>


                    <div id="streak">
                        <!-- Streak chart will be loaded here -->
                        <?php include('endpoint/streak_tracker.php'); ?>
                    </div>
                </div>



        </div>


        <!-- Chart.js -->
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


    </main>

    <!-- quiz modal -->
    <div class="quiz-modal" id="quiz-modal">
        <div class="quiz-modal-card">
            <div class="cross-icon" onclick="closeModal()">
                <i class="fas fa-xmark"></i>
            </div>
            <h1>Mental Health Self-Assessment Quiz</h1>
            <form id="quizForm">
                <div id="questionsContainer" class="question-container">
                    <!-- Questions will be dynamically generated here -->
                </div>
                <button type="submit" onclick="submitQuiz()">Submit Quiz</button>
            </form>

        </div>
    </div>
    <!--end of quiz modal -->

    <!-- Bootstrap and JQuery scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>

    <script>
        // Sidebar submenu toggle
        document.querySelectorAll('.submenu-toggle').forEach(toggle => {
            toggle.addEventListener('click', () => {
                const submenu = toggle.nextElementSibling;
                const arrow = toggle.querySelector('.menu-arrow');

                if (submenu.classList.contains('open')) {
                    submenu.classList.remove('open');
                    arrow.classList.remove('rotate');
                } else {
                    submenu.classList.add('open');
                    arrow.classList.add('rotate');
                }
            });
        });

        // Optional: Sidebar collapse on small screen
        function checkWindowSize() {
            const sidebar = document.getElementById('sidebar');
            if (window.innerWidth < 576) {
                sidebar.classList.add('collapsed');
            } else {
                sidebar.classList.remove('collapsed');
            }
        }
        window.addEventListener('resize', checkWindowSize);
        window.addEventListener('load', checkWindowSize);
    </script>

    <script>
        let selectedMood = null;

        function selectMood(btn) {
            document.querySelectorAll('.mood-btn').forEach(b => b.classList.remove('active'));
            btn.classList.add('active');
            selectedMood = btn.getAttribute('data-mood');
        }

        function submitMood() {
            const note = document.getElementById('moodNote').value;

            if (!selectedMood) {
                alert("Please select your mood.");
                return;
            }

            // Send to PHP backend via fetch()
            fetch('endpoint/daily_mood.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        mood: selectedMood,
                        suggestion: note
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        alert("Mood saved successfully!");
                        // Reset
                        document.querySelectorAll('.mood-btn').forEach(b => b.classList.remove('active'));
                        document.getElementById('moodNote').value = '';
                        selectedMood = null;
                    } else {
                        alert("Error: " + data.message);
                    }
                })
                .catch(error => {
                    console.error('Fetch error:', error);
                    alert("Something went wrong while saving your mood.");
                });
        }
    </script>


    <script>
        let moodChart;

        function closeNav() {
            document.getElementById("mobile-nav").classList.remove("active");
        }

        function openNav() {
            document.getElementById("mobile-nav").classList.add("active");
        }

        function openModal() {
            document.getElementById("quiz-modal").style.display = "flex";
            loadQuiz();
        }

        function closeModal() {
            document.getElementById("quiz-modal").style.display = "none";
            resetQuiz();
        }

        function updateMoodHistory() {
            const moodButton = document.getElementById("mood-button");
            const moods = JSON.parse(localStorage.getItem("moodTracker")) || [];

            if (moods.length > 0) {
                const latestEntry = moods[moods.length - 1];
                moodButton.textContent = `Mood: ${latestEntry.mood}`;
                moodButton.setAttribute('aria-label', `Mood ${latestEntry.mood} Button`);
            } else {
                moodButton.textContent = "Mood: None";
                moodButton.setAttribute('aria-label', "Mood None Button");
            }
        }

        function updateChart() {
            const ctx = document.getElementById("mood-chart").getContext("2d");

            fetch("endpoint/get_mood_data.php")
                .then(response => response.json())
                .then(moods => {
                    const labels = moods.map(m => m.mood);
                    const data = moods.map(m => m.count);

                    if (moodChart) {
                        moodChart.data.labels = labels;
                        moodChart.data.datasets[0].data = data;
                        moodChart.update();
                    } else {
                        moodChart = new Chart(ctx, {
                            type: "bar",
                            data: {
                                labels: labels,
                                datasets: [{
                                    label: "Mood Frequency",
                                    data: data,
                                    backgroundColor: [
                                        "#4CAF50", "#FF5733", "#FFC300",
                                        "#33C3FF", "#FF33C4", "#33FF57"
                                    ],
                                    borderWidth: 1
                                }]
                            },
                            options: {
                                scales: {
                                    y: {
                                        beginAtZero: true
                                    }
                                }
                            }
                        });
                    }
                })
                .catch(error => {
                    console.error("Failed to fetch mood data:", error);
                });
        }

        document.addEventListener("DOMContentLoaded", () => {
            updateChart();
            updateMoodHistory();
        });

        function loadQuiz() {
            const questions = [
                "How often do you feel overwhelmed by daily tasks?",
                "How often do you have trouble sleeping?",
                "Do you feel anxious without any specific reason?",
                "Do you often feel down or hopeless?",
                "How often do you struggle to enjoy activities you used to like?",
                "Do you find it hard to focus on work or studies?",
                "How often do you feel isolated or lonely?",
                "Do you get easily irritated or angry?",
                "How often do you feel tired or have low energy?",
                "Do you worry about your health frequently?",
                "How often do you avoid social situations?",
                "Do you experience sudden mood changes?",
                "How often do you feel restless or unable to relax?",
                "Do you struggle with low self-esteem?",
                "How often do you feel nervous or on edge?",
                "Do you have difficulty managing your stress levels?",
                "How often do you feel like crying without any particular reason?",
                "Do you experience frequent headaches or physical tension?",
                "How often do you feel guilty or blame yourself?",
                "Do you feel disconnected from reality at times?",
                "How often do you feel out of control with your emotions?",
                "Do you find it hard to make decisions?",
                "How often do you engage in negative self-talk?",
                "Do you feel like your mind is racing with thoughts?",
                "How often do you feel unmotivated or apathetic?"
            ];

            function getRandomQuestions(questions) {
                return questions.sort(() => 0.5 - Math.random()).slice(0, 10);
            }

            const randomQuestions = getRandomQuestions(questions);
            const questionsContainer = document.getElementById("questionsContainer");
            questionsContainer.innerHTML = "";

            randomQuestions.forEach((question, index) => {
                const questionDiv = document.createElement("div");
                questionDiv.classList.add("question");
                questionDiv.innerHTML = `
                <p>${index + 1}. ${question}</p>
                <label><input type="radio" name="q${index + 1}" value="1"> Rarely</label>
                <label><input type="radio" name="q${index + 1}" value="2"> Sometimes</label>
                <label><input type="radio" name="q${index + 1}" value="3"> Often</label>
                <label><input type="radio" name="q${index + 1}" value="4"> Always</label>
            `;
                questionsContainer.appendChild(questionDiv);
            });

            document.getElementById("quizForm").addEventListener("submit", function(event) {
                event.preventDefault();
                let score = 0;

                for (let i = 1; i <= 10; i++) {
                    const selectedOption = document.querySelector(`input[name="q${i}"]:checked`);
                    if (selectedOption) {
                        score += parseInt(selectedOption.value);
                    }
                }

                displayResult(score);
                closeModal();
            });
        }

        function displayResult(score) {
            const result = document.getElementById("result");
            const moodAnalysis = document.getElementById("moodAnalysis");
            const meditationSuggestion = document.getElementById("meditationSuggestion");

            let mood = "";
            let suggestion = "";

            if (score <= 10) {
                mood = "Happy";
                suggestion = "Gratitude Meditation: Reflect on things you're grateful for.";
            } else if (score <= 15) {
                mood = "Anxious";
                suggestion = "Breathing Exercise: Deep, slow breaths to relax.";
            } else if (score <= 20) {
                mood = "Stressed";
                suggestion = "Mindful Breathing: Focus on your breath to reduce stress.";
            } else {
                mood = "Overwhelmed";
                suggestion = "Body Scan Meditation: Help your mind reconnect with your body.";
            }

            moodAnalysis.textContent = mood;
            meditationSuggestion.textContent = suggestion;
            result.classList.remove("hidden");

            const moodTracker = JSON.parse(localStorage.getItem("moodTracker")) || [];
            moodTracker.push({
                mood: mood,
                timestamp: new Date().toISOString()
            });
            localStorage.setItem("moodTracker", JSON.stringify(moodTracker));
            updateMoodHistory();
            updateChart();

            fetch('endpoint/save_mood.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        score: score,
                        mood: mood,
                        suggestion: suggestion
                    })
                })
                .then(res => res.json())
                .then(data => {
                    if (data.status !== 'success') {
                        alert('Failed to save result: ' + data.message);
                    }
                })
                .catch(err => {
                    console.error('Error:', err);
                    alert('Failed to save to server.');
                });
        }

        function resetQuiz() {
            document.getElementById("quizForm").reset();
            document.getElementById("result").classList.add("hidden");
        }

        document.addEventListener("DOMContentLoaded", () => {
            const form = document.getElementById("mood-form");
            const moodSelect = document.getElementById("mood");

            const moods = JSON.parse(localStorage.getItem("moodTracker")) || [];

            form.addEventListener("submit", (e) => {
                e.preventDefault();
                const mood = moodSelect.value;
                if (!mood) return;

                const now = new Date();
                const date = now.toLocaleDateString();
                const time = now.toLocaleTimeString();

                moods.push({
                    date,
                    time,
                    mood
                });
                localStorage.setItem("moodTracker", JSON.stringify(moods));
                updateMoodHistory();
                updateChart();
                moodSelect.value = "";
            });

            updateMoodHistory();
            updateChart();

            function getRandomItems(container, count) {
                const items = Array.from(container.querySelectorAll(".card"));
                const shuffled = items.sort(() => 0.5 - Math.random()).slice(0, count);
                container.innerHTML = "";
                shuffled.forEach(item => container.appendChild(item));
            }

            const videoContainer = document.querySelector('.videos-container .container');
            const articleContainer = document.querySelector('.article-container .container');
            const podcastContainer = document.querySelector('.podcast-container .container');

            if (videoContainer && articleContainer && podcastContainer) {
                getRandomItems(videoContainer, 3);
                getRandomItems(articleContainer, 3);
                getRandomItems(podcastContainer, 3);
            }
        });
    </script>

    <script>
        const chartCanvas = document.getElementById("mood-chart");

        // ✅ Export Button Logic
        document.getElementById("exportChartBtn").addEventListener("click", function() {
            if (!chartCanvas) {
                alert("Mood chart not found!");
                return;
            }

            const imageData = chartCanvas.toDataURL("image/png");
            const a = document.createElement("a");
            a.href = imageData;
            a.download = "MoodChart.png";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        });

        // ✅ Print Button Logic
        document.getElementById("printChartBtn").addEventListener("click", function() {
            if (!chartCanvas) {
                alert("Mood chart not found!");
                return;
            }

            const chartDataURL = chartCanvas.toDataURL("image/png");
            const moodHistoryTableHTML = document.querySelector(".table-responsive")?.innerHTML || "<p>No table found.</p>";

            const printWindow = window.open('', '_blank');
            printWindow.document.write(`
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <title>User Mood Report</title>
            <style>
                body {
                    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                    margin: 40px;
                    background-color: #fff;
                    color: #333;
                }
                header {
                    text-align: center;
                    margin-bottom: 40px;
                }
                header h1 {
                    margin: 0;
                    font-size: 26px;
                    color: #004085;
                }
                header p {
                    margin: 5px 0 0;
                    font-size: 14px;
                    color: #555;
                }
                .section {
                    margin-bottom: 30px;
                }
                .section h2 {
                    font-size: 20px;
                    color: #0056b3;
                    border-bottom: 1px solid #ddd;
                    padding-bottom: 5px;
                    margin-bottom: 15px;
                }
                .section img {
                    display: block;
                    margin: 0 auto;
                    max-width: 100%;
                    height: auto;
                    border: 1px solid #ccc;
                    padding: 10px;
                    border-radius: 10px;
                }
                table {
                    width: 100%;
                    border-collapse: collapse;
                    margin-top: 10px;
                }
                th, td {
                    border: 1px solid #ddd;
                    padding: 8px;
                    font-size: 14px;
                }
                th {
                    background-color: #343a40;
                    color: white;
                }
                td.text-start {
                    text-align: left;
                }
                .footer {
                    text-align: center;
                    margin-top: 50px;
                    font-size: 12px;
                    color: #777;
                    border-top: 1px solid #ddd;
                    padding-top: 10px;
                }
            </style>
        </head>
        <body>
            <header>
                <h1>Mood Tracking Report</h1>
                <p>Generated by WellBeing System</p>
            </header>

            <div class="section">
                <h2>Mood Chart Overview</h2>
                <img id="chartImage" src="${chartDataURL}" alt="Mood Chart"/>
            </div>

            <div class="section">
                <h2>Mood Quiz History</h2>
                ${moodHistoryTableHTML}
            </div>

            <div class="footer">
                Report generated on ${new Date().toLocaleString()}
            </div>
        </body>
        </html>`);

            printWindow.document.close();

            printWindow.onload = () => {
                const chartImage = printWindow.document.getElementById("chartImage");

                const safePrint = () => {
                    printWindow.focus();
                    printWindow.print();
                };

                if (chartImage.complete) {
                    safePrint();
                } else {
                    chartImage.onload = safePrint;
                    setTimeout(safePrint, 1500); // Fallback
                }
            };
        });
    </script>



    <!--Start of Tawk.to Script-->
    <script type="text/javascript">
        var Tawk_API = Tawk_API || {},
            Tawk_LoadStart = new Date();
        (function() {
            var s1 = document.createElement("script"),
                s0 = document.getElementsByTagName("script")[0];
            s1.async = true;
            s1.src = 'https://embed.tawk.to/68086a31803f261911f99216/1ipgdtkrc';
            s1.charset = 'UTF-8';
            s1.setAttribute('crossorigin', '*');
            s0.parentNode.insertBefore(s1, s0);
        })();
    </script>
    <!--End of Tawk.to Script-->

</body>

</html>