<?php
session_start();
require 'conn/conn.php'; // Adjust if needed

// Redirect if not logged in
if (!isset($_SESSION['email'])) {
    header("Location: index.php");
    exit();
}

$email = $_SESSION['email'];

try {
    // Fetch all user data
    $stmt = $conn->prepare("SELECT * FROM tbl_user WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        // Invalid session or user deleted
        session_destroy();
        header("Location: index.php");
        exit();
    }

    // Determine image path
    $imagePath = (!empty($user['profile_image']) && file_exists("uploads/" . $user['profile_image']))
        ? "uploads/" . $user['profile_image']
        : "images/default-profile.jpg";
} catch (PDOException $e) {
    echo "Database error: " . $e->getMessage();
    exit();
}
?>




<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>WellBeing | Student Profile</title>

    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat&family=Ubuntu&display=swap"
        rel="stylesheet" />
    <link
        href="https://fonts.googleapis.com/css2?family=Satisfy&display=swap"
        rel="stylesheet" />

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet" />
    <link
        rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
        crossorigin="anonymous"
        referrerpolicy="no-referrer" />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    <!-- Bootstrap CSS -->
    <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
        rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">


    <!-- Font Awesome -->
    <link
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
        rel="stylesheet" />

    <link rel="stylesheet" href="css/session.css" />
    <link rel="stylesheet" href="css/responsive.css" />
    <link rel="icon" href="images/logo.png" type="image/png">

</head>

<body>
    <!-- Sidebar -->
    <aside id="sidebar" aria-label="Sidebar Navigation">
        <div class="logo" aria-label="Logo">
            <img src="images/logo.png" alt="logo" class="logo-img" />
            <span class="logo-text"> WELLBEING </span>
        </div>
        <nav>
            <ul>
                <li>
                    <a href="User.php" class="with-badge">
                        <i class="fas fa-tachometer-alt mr-2"></i>
                        <span class="text">Dashboard</span>
                    </a>
                </li>
                <li>
                    <a href="Resources.php" class="with-badge">
                        <i class="fas fa-th-large mr-2"></i>
                        <span class="text"> Resources</span>
                    </a>
                </li>
                <li>
                    <a href="appointment.php" class="with-badge">
                        <i class="fas fa-book mr-2"></i>
                        <span class="text"> Appointment</span>
                    </a>
                </li>
                <li>
                    <a href="session.php" class="with-badge">
                        <i class="fas fa-calendar-check mr-2"></i>
                        <span class="text"> Session</span>
                    </a>
                </li>
                <li>
                    <a href="Forum.php" class="with-badge">
                        <i class="fas fa-comments mr-2"></i>
                        <span class="text"> Student Space</span>
                    </a>

                </li>
                <li>
                    <a href="#" class="active">
                        <i class="fas fa-edit mr-2"></i>
                        <span class="text"> Profile</span>
                    </a>

                </li>
                <li class="menu-item-collapsible">
                    <a
                        href="javascript:void(0);"
                        class="d-flex align-items-center justify-content-between submenu-toggle">
                        <span><i class="fas fa-layer-group mr-2"></i><span class="text"> Menu Levels</span></span>
                        <i class="fas fa-angle-right menu-arrow"></i>
                    </a>
                    <ul class="submenu list-unstyled">
                        <li><a href="#">Level 1</a></li>
                        <li><a href="#">Level 2</a></li>
                        <li><a href="#">Level 3</a></li>
                    </ul>
                </li>
            </ul>
        </nav>
    </aside>

    <!-- Top Navigation -->
    <header id="topnav" role="banner" aria-label="Top Navigation Bar">
        <div id="search-bar" aria-label="Site Search">
            <input type="search" aria-label="Search" placeholder="Search..." />
            <i class="fas fa-search"></i>
        </div>

        <div class="nav-icons">
            <i
                class="fas fa-bell"
                aria-label="Notifications"
                title="Notifications"
                tabindex="0"></i>
            <div class="user-profile" tabindex="0" aria-label="User Profile">
                <span class="greeting">Hi, <?= htmlspecialchars($user['first_name']) ?></span>
                <img src="<?= htmlspecialchars($imagePath) ?>" alt="User Profile Picture" class="rounded-circle" style="width: 40px; height: 40px; object-fit: cover;">
            </div>

        </div>
    </header>

    <main id="main-content" role="main" class="d-flex align-items-center justify-content-center min-vh-100 py-5" style="background-color: #f4f6f9;">
        <div class="card shadow-lg border-0 rounded-4 p-5 w-100 mx-3" style="max-width: 1000px; background-color: #ffffff;">
            <!-- Combined Profile Form + Image Upload -->
            <form action="endpoint/update_profile.php" method="POST" enctype="multipart/form-data" class="px-md-5">
                <div class="text-center mb-4">
                    <img src="<?= htmlspecialchars($imagePath) ?>" alt="Profile Image" class="rounded-circle shadow"
                        style="width: 160px; height: 160px; object-fit: cover; border: 4px solid #0d6efd;">
                    <h2 class="mt-3 fw-bold"><?= htmlspecialchars($user['first_name']) ?> <?= htmlspecialchars($user['last_name']) ?></h2>
                    <p class="text-muted">Matric ID: <?= htmlspecialchars($user['matric_id']) ?></p>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-semibold">First Name</label>
                        <input type="text" name="first_name" class="form-control" value="<?= htmlspecialchars($user['first_name']) ?>" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-semibold">Last Name</label>
                        <input type="text" name="last_name" class="form-control" value="<?= htmlspecialchars($user['last_name']) ?>" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-semibold">Contact Number</label>
                        <input type="text" name="contact_number" class="form-control" value="<?= htmlspecialchars($user['contact_number']) ?>" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-semibold">Gender</label>
                        <select name="gender" class="form-select" required>
                            <option value="Male" <?= $user['gender'] === 'Male' ? 'selected' : '' ?>>Male</option>
                            <option value="Female" <?= $user['gender'] === 'Female' ? 'selected' : '' ?>>Female</option>
                        </select>
                    </div>
                    <div class="col-12 mb-4">
                        <label class="form-label fw-semibold">Email</label>
                        <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($user['email']) ?>" required>
                    </div>

                    <!-- Upload Image Inside Same Form -->
                    <div class="col-12 mb-4">
                        <label class="form-label fw-semibold">Upload New Profile Image</label>
                        <input class="form-control" type="file" name="profile_image" accept="image/*">
                    </div>
                </div>

                <div class="text-center">
                    <button type="submit" class="btn btn-success btn-lg rounded-pill px-5 py-2">
                        <i class="fas fa-save me-2"></i> Save Changes
                    </button>
                </div>
            </form>

            <!-- Feedback Button -->
            <div class="text-center mt-4">
                <button type="button" class="btn btn-outline-primary btn-lg rounded-pill px-5 py-2" data-bs-toggle="modal" data-bs-target="#feedbackModal">
                    <i class="fas fa-comment me-2"></i> Feedback
                </button>
            </div>

            <!-- Feedback Modal -->
            <div class="modal fade" id="feedbackModal" tabindex="-1" aria-labelledby="feedbackModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <form action="endpoint/submit_feedback.php" method="POST" class="modal-content border-0 shadow rounded-4">
                        <div class="modal-header bg-primary text-white">
                            <h5 class="modal-title" id="feedbackModalLabel"><i class="fas fa-comment-dots me-2"></i>Submit Feedback</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body px-4 py-3">
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Full Name</label>
                                <input type="text" name="full_name" class="form-control" value="<?= htmlspecialchars($user['first_name'] . ' ' . $user['last_name']) ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Email</label>
                                <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($user['email']) ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Your Feedback</label>
                                <textarea name="feedback_text" class="form-control" rows="4" placeholder="Write your feedback here..." required></textarea>
                            </div>
                        </div>
                        <div class="modal-footer border-0 px-4 pb-4">
                            <button type="submit" class="btn btn-primary rounded-pill w-100">
                                <i class="fas fa-paper-plane me-2"></i> Submit Feedback
                            </button>
                        </div>
                    </form>
                </div>
            </div>


        </div>
    </main>

    <!-- Bootstrap 5 JS Bundle (includes Popper) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        const formData = new FormData();
        formData.append('profile_image', document.querySelector('#profileImageInput').files[0]);

        fetch('endpoint/upload_profile_image.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    alert('Image uploaded!');
                    // Optional: Update image preview
                } else {
                    alert(data.message);
                }
            })
            .catch(error => console.error('Upload error:', error));
    </script>


    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        document.getElementById("uploadForm").addEventListener("submit", function(e) {
            e.preventDefault();

            const formData = new FormData(this);

            fetch('endpoint/upload_profile_image.php', {
                    method: 'POST',
                    body: formData
                })
                .then(res => res.json())
                .then(data => {
                    if (data.status === 'success') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Upload Successful',
                            text: 'Your profile image has been updated!',
                            confirmButtonColor: '#3085d6'
                        }).then(() => {
                            location.reload(); // Optional: refresh to show updated image
                        });
                    } else {
                        Swal.fire('Error', data.message, 'error');
                    }
                })
                .catch(error => {
                    Swal.fire('Error', 'Something went wrong!', 'error');
                    console.error(error);
                });
        });
    </script>

    <?php if (isset($_GET['upload']) && $_GET['upload'] === 'success'): ?>
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Upload Successful',
                text: 'Your profile image has been updated!',
                confirmButtonColor: '#3085d6'
            });
        </script>
    <?php endif; ?>

</body>

</html>