<?php
session_start();
include 'conn/conn.php';

// Handle Add Student
if (isset($_POST['add_student'])) {
  $name = $_POST['student_name'];
  $course = $_POST['student_course'];

  // Removed username from insert query
  $stmt = $conn->prepare("INSERT INTO students (name, course) VALUES (?, ?)");
  $stmt->execute([$name, $course]);

  echo "<script>alert('Student added successfully.'); window.location='admin.php';</script>";
  exit();
}

// Handle Update User
if (isset($_POST['update_user'])) {
  $table = $_POST['user_type'] === 'student' ? 'students' : 'counselors';
  $id = $_POST['user_id'];
  $name = $_POST['new_name'];

  $stmt = $conn->prepare("UPDATE $table SET name = ? WHERE id = ?");
  $stmt->execute([$name, $id]);

  echo "<script>alert('User updated successfully.'); window.location='admin.php';</script>";
  exit();
}
?>







<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>WellBeing | Manage Users</title>

  <link
    href="https://fonts.googleapis.com/css2?family=Montserrat&family=Ubuntu&display=swap"
    rel="stylesheet" />
  <link
    href="https://fonts.googleapis.com/css2?family=Satisfy&display=swap"
    rel="stylesheet" />

  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link
    href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
    rel="stylesheet" />
  <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
    integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
    crossorigin="anonymous"
    referrerpolicy="no-referrer" />
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <!-- Add this in your <head> or before </body> -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


  <!-- Bootstrap CSS -->
  <link
    href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
    rel="stylesheet" />
  <!-- Font Awesome -->
  <link
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
    rel="stylesheet" />

  <link rel="stylesheet" href="css/admin.css" />
  <link rel="stylesheet" href="css/responsive.css" />

  <link rel="icon" href="images/logo.png" type="image/png">

</head>

<body>
  <!-- Sidebar -->
  <aside id="sidebar" aria-label="Sidebar Navigation">
    <div class="logo" aria-label="Logo">
      <img src="images/logo.png" alt="logo" class="logo-img">
      <span class="logo-text"> WELLBEING </span>
    </div>
    <nav>
      <ul>
        <li>
          <a href="AdminDashboard.php" class="with-badge">
            <i class="fas fa-tachometer-alt mr-2"></i>
            <span class="text">Dashboard</span>
          </a>
        </li>
        <li>
          <a href="ManageCounselor.php" class="with-badge">
            <i class="fas fa-hand-holding-medical mr-2"></i>
            <span class="text"> Counselors</span>
          </a>
        </li>
        <li>
          <a href="admin.php" class="active">
            <i class="fas fa-users mr-2"></i>
            <span class="text"> Manage User</span>
          </a>
        </li>
        <li class="menu-item-collapsible">
          <a href="javascript:void(0);" class="d-flex align-items-center justify-content-between submenu-toggle">
            <span><i class="fas fa-layer-group mr-2"></i><span class="text"> Menu Levels</span></span>
            <i class="fas fa-angle-right menu-arrow"></i>
          </a>
          <ul class="submenu list-unstyled">
            <li><a href="#">Level 1</a></li>
            <li><a href="#">Level 2</a></li>
            <li><a href="#">Level 3</a></li>
          </ul>
        </li>
      </ul>
    </nav>
  </aside>

  <!-- Top Navigation -->
  <header id="topnav" role="banner" aria-label="Top Navigation Bar">

    <div id="search-bar" aria-label="Site Search">
      <input type="search" aria-label="Search" placeholder="Search..." />
      <i class="fas fa-search"></i>
    </div>
    <div class="nav-icons">
      <i
        class="fas fa-bell"
        aria-label="Notifications"
        title="Notifications"
        tabindex="0"></i>
      <div class="user-profile" tabindex="0" aria-label="User Profile">
        <span class="greeting">Hi, Syazwi</span>
        <img src="images/awi .jpg" alt="User Profile Picture" />
      </div>
    </div>
  </header>

  <main id="main-content" role="main">
    <!-- Update Modal -->
    <div class="modal fade mt-5" id="updateUserModal" tabindex="-1">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Update User</h5>
            <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
          </div>
          <div class="modal-body">
            <form action="./endpoint/update-user.php" method="POST">
              <input type="hidden" name="tbl_user_id" id="updateUserID">
              <div class="form-group row">
                <div class="col-md-6">
                  <label for="updateFirstName">First Name:</label>
                  <input type="text" class="form-control" id="updateFirstName" name="first_name">
                </div>
                <div class="col-md-6">
                  <label for="updateLastName">Last Name:</label>
                  <input type="text" class="form-control" id="updateLastName" name="last_name">
                </div>
              </div>
              <div class="form-group row">
                <div class="col-md-5">
                  <label for="updateContactNumber">Contact Number:</label>
                  <input type="number" class="form-control" id="updateContactNumber" name="contact_number">
                </div>
                <div class="col-md-7">
                  <label for="updateEmail">Email:</label>
                  <input type="text" class="form-control" id="updateEmail" name="email">
                </div>
              </div>
              <div class="form-group">
                <label for="updatePassword">Password:</label>
                <input type="text" class="form-control" id="updatePassword" name="password">
              </div>
              <div class="form-group">
                <label for="updateRole">Role:</label>
                <select class="form-control" id="updateRole" name="role">
                  <option value="User">User</option>
                  <option value="Admin">Admin</option>
                </select>
              </div>
              <button type="submit" class="btn btn-dark form-control">Update</button>
            </form>
          </div>
        </div>
      </div>
    </div>

    <!-- Admin Manage User Section -->
    <section class="container mt-5">
      <div class="card shadow-sm">
        <div class="card-header bg-info text-white">
          <h5 class="mb-0">List of Users</h5>
        </div>
        <div class="card-body bg-white">
          <div class="mb-3">
            <input
              type="search"
              id="searchUser"
              class="form-control"
              placeholder="Search User..."
              aria-label="Search User" />
          </div>

          <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle mb-0">
              <thead class="table-light">
                <tr>
                  <th>User ID</th>
                  <th>First Name</th>
                  <th>Last Name</th>
                  <th>Matric Id</th>
                  <th>Gender</th>
                  <th>Contact Number</th>
                  <th>Email</th>
                  <th>Role</th>
                  <th>Created At</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody>
                <?php
                $stmt = $conn->prepare("SELECT * FROM `tbl_user` WHERE role IN ('student', 'Admin')");
                $stmt->execute();
                $result = $stmt->fetchAll();

                foreach ($result as $row):
                  $userID = $row['tbl_user_id'];
                ?>
                  <tr>
                    <td id="userID-<?= $userID ?>"><?= htmlspecialchars($row['tbl_user_id']) ?></td>
                    <td id="firstName-<?= $userID ?>"><?= htmlspecialchars($row['first_name']) ?></td>
                    <td id="lastName-<?= $userID ?>"><?= htmlspecialchars($row['last_name']) ?></td>
                    <td id="matricId-<?= $userID ?>"><?= htmlspecialchars($row['matric_id']) ?></td>
                    <td id="gender-<?= $userID ?>"><?= htmlspecialchars($row['gender']) ?></td>
                    <td id="contactNumber-<?= $userID ?>"><?= htmlspecialchars($row['contact_number']) ?></td>
                    <td id="email-<?= $userID ?>"><?= htmlspecialchars($row['email']) ?></td>
                    <td id="role-<?= $userID ?>"><?= htmlspecialchars($row['role']) ?></td>
                    <td id="createdAt-<?= $userID ?>"><?= htmlspecialchars($row['created_at']) ?></td>
                    <td>
                      <button
                        class="btn btn-sm btn-primary"
                        onclick="update_user(<?= $userID ?>)">✏️</button>
                      <button
                        class="btn btn-sm btn-danger"
                        onclick="delete_user(<?= $userID ?>)">🗑️</button>
                    </td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </section>

    <script>
      function update_user(id) {
        $("#updateUserModal").modal("show");

        $("#updateUserID").val($("#userID-" + id).text());
        $("#updateFirstName").val($("#firstName-" + id).text());
        $("#updateLastName").val($("#lastName-" + id).text());
        $("#updateContactNumber").val($("#contactNumber-" + id).text());
        $("#updateEmail").val($("#email-" + id).text());
        $("#updatePassword").val(""); // Do not prefill password
        $("#updateRole").val($("#role-" + id).text());
      }

      function delete_user(id) {
        if (confirm("Do you want to delete this user?")) {
          window.location = "./endpoint/delete-user.php?user=" + id;
        }
      }

      document.getElementById('searchUser').addEventListener('input', function() {
        const searchValue = this.value.toLowerCase();
        const rows = document.querySelectorAll("table tbody tr");

        rows.forEach(row => {
          const firstName = row.querySelector("td[id^='firstName-']").textContent.toLowerCase();
          const lastName = row.querySelector("td[id^='lastName-']").textContent.toLowerCase();

          if (
            firstName.includes(searchValue) ||
            lastName.includes(searchValue)
          ) {
            row.style.display = "";
          } else {
            row.style.display = "none";
          }
        });
      });
    </script>

    <!-- Bootstrap Js -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js"></script>
  </main>

</body>

</html>