<?php
session_start();
include 'conn/conn.php'; // Ensure this connects correctly to your DB


// Check if user is logged in
if (!isset($_SESSION['email'])) {
  header("Location: index.php");
  exit();
}

$email = $_SESSION['email'];


// Fetch all counselors
$stmt = $conn->prepare("SELECT name, specialization, profile_image FROM counselors");
$stmt->execute();
$counselors = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch user's first name and profile image
try {
  $stmt = $conn->prepare("SELECT first_name, profile_image FROM tbl_user WHERE email = ?");
  $stmt->execute([$email]);
  $user = $stmt->fetch(PDO::FETCH_ASSOC);

  $imagePath = (!empty($user['profile_image']) && file_exists("uploads/" . $user['profile_image']))
    ? "uploads/" . $user['profile_image']
    : "images/default-profile.jpg"; // fallback
} catch (PDOException $e) {
  $user = ['first_name' => 'Guest'];
  $imagePath = "images/default-profile.jpg";
}

// Get logged-in email
$student_email = $_SESSION['email'] ?? 'Guest';
$student_matric_id = '';
$student_fullname = '';

if ($student_email !== 'Guest') {
  $stmt = $conn->prepare("SELECT first_name, last_name, matric_id, gender FROM tbl_user WHERE email = :email"); // ✅ Include gender
  $stmt->bindParam(':email', $student_email);
  $stmt->execute();
  $user = $stmt->fetch(PDO::FETCH_ASSOC);

  if ($user) {
    $student_matric_id = $user['matric_id'];
    $student_fullname = trim($user['first_name'] . ' ' . $user['last_name']);
    $student_gender = $user['gender']; // ✅ Save gender
  }
}

// Handle appointment cancellation
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['appointment_id'])) {
  $appointment_id = $_POST['appointment_id'];

  // Ensure only own appointment can be cancelled
  $verify_stmt = $conn->prepare("SELECT * FROM appointments WHERE id = :id AND matric_id = :matric_id");
  $verify_stmt->bindParam(':id', $appointment_id);
  $verify_stmt->bindParam(':matric_id', $student_matric_id);
  $verify_stmt->execute();
  $appointment = $verify_stmt->fetch(PDO::FETCH_ASSOC);

  if ($appointment) {
    $del_stmt = $conn->prepare("DELETE FROM appointments WHERE id = :id");
    $del_stmt->bindParam(':id', $appointment_id);
    if ($del_stmt->execute()) {
      $message = "Appointment canceled successfully.";
    } else {
      $message = "Failed to cancel appointment. Please try again.";
    }
  } else {
    $message = "You don't have permission to cancel this appointment.";
  }
}

// Fetch counselor list
$stmt = $conn->prepare("SELECT * FROM counselors");
$stmt->execute();
$counselors = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch student appointments using matric_id
$appointments = [];
if ($student_email !== 'Guest' && $student_matric_id !== '') {
  $appt_stmt = $conn->prepare("SELECT * FROM appointments WHERE matric_id = :matric_id");
  $appt_stmt->bindParam(':matric_id', $student_matric_id);
  $appt_stmt->execute();
  $appointments = $appt_stmt->fetchAll(PDO::FETCH_ASSOC);
}


?>








<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>WellBeing | User Dashboard</title>

  <link
    href="https://fonts.googleapis.com/css2?family=Montserrat&family=Ubuntu&display=swap"
    rel="stylesheet" />
  <link
    href="https://fonts.googleapis.com/css2?family=Satisfy&display=swap"
    rel="stylesheet" />

  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link
    href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
    rel="stylesheet" />
  <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
    integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
    crossorigin="anonymous"
    referrerpolicy="no-referrer" />
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

  <!-- Bootstrap CSS -->
  <link
    href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
    rel="stylesheet" />
  <!-- Font Awesome -->
  <link
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
    rel="stylesheet" />

  <link rel="stylesheet" href="css/appointment.css" />
  <link rel="stylesheet" href="css/responsive.css" />

  <link rel="icon" href="images/logo.png" type="image/png">
</head>

<body>
  <!-- Sidebar -->
  <aside id="sidebar" aria-label="Sidebar Navigation">
    <div class="logo" aria-label="Logo">
      <img src="images/logo.png" alt="logo" class="logo-img">
      <span class="logo-text"> WELLBEING </span>
    </div>
    <nav>
      <ul>
        <li>
          <a href="User.php" class="with-badge">
            <i class="fas fa-tachometer-alt mr-2"></i>
            <span class="text">Dashboard</span>
          </a>
        </li>
        <li>
          <a href="Resources.php" class="with-badge">
            <i class="fas fa-th-large mr-2"></i>
            <span class="text"> Resources</span>
          </a>
        </li>
        <li>
          <a href="appointment.php" class="active">
            <i class="fas fa-book mr-2"></i>
            <span class="text"> Appointment</span>
          </a>
        </li>
        <li>
          <a href="session.php" class="with-badge">
            <i class="fas fa-calendar-check mr-2"></i>
            <span class="text"> Session</span>
          </a>
        </li>
        <li>
          <a href="Forum.php" class="with-badge">
            <i class="fas fa-comments mr-2"></i>
            <span class="text"> Student Space</span>
          </a>

        </li>
        <li>
          <a href="UserProfile.php" class="with-badge">
            <i class="fas fa-edit mr-2"></i>
            <span class="text"> Profile</span>
          </a>

        </li>
        <li class="menu-item-collapsible">
          <a
            href="javascript:void(0);"
            class="d-flex align-items-center justify-content-between submenu-toggle">
            <span><i class="fas fa-layer-group mr-2"></i><span class="text"> Menu Levels</span></span>
            <i class="fas fa-angle-right menu-arrow"></i>
          </a>
          <ul class="submenu list-unstyled">
            <li><a href="#">Level 1</a></li>
            <li><a href="#">Level 2</a></li>
            <li><a href="#">Level 3</a></li>
          </ul>
        </li>
      </ul>
    </nav>
  </aside>

  <!-- Top Navigation -->
  <header id="topnav" role="banner" aria-label="Top Navigation Bar">
    <div id="search-bar" aria-label="Site Search">
      <input type="search" aria-label="Search" placeholder="Search..." />
      <i class="fas fa-search"></i>
    </div>

    <div class="nav-icons">
      <i
        class="fas fa-bell"
        aria-label="Notifications"
        title="Notifications"
        tabindex="0"></i>
      <div class="user-profile" tabindex="0" aria-label="User Profile">
        <span class="greeting">Hi, <?= htmlspecialchars($user['first_name']) ?></span>
        <a href="UserProfile.php">
          <img src="<?= htmlspecialchars($imagePath) ?>" alt="User Profile Picture"
            class="rounded-circle" style="width: 40px; height: 40px; object-fit: cover;">
        </a>
      </div>

    </div>
  </header>

  <!-- Main Content -->
  <main id="main-content" role="main">
    <div class="card-row">
      <?php foreach ($counselors as $counselor): ?>
        <div class="card">
          <!-- Front: Counselor Picture -->
          <img
            src="<?= htmlspecialchars(!empty($counselor['profile_image']) ? 'uploads/' . $counselor['profile_image'] : 'images/default-profile.jpg') ?>"
            alt="<?= htmlspecialchars($counselor['name']) ?>"
            class="card__image" />

          <!-- Back: Counselor Info -->
          <div class="card__content">
            <p class="card__title"><?= htmlspecialchars($counselor['name']) ?></p>
            <p class="card__description">
              <?= htmlspecialchars($counselor['specialization']) ?>
            </p>
          </div>
        </div>
      <?php endforeach; ?>
    </div>


    <!-- Appointment Section -->
    <section id="appointment-section" class="booking-section mt-5">
      <div class="container">
        <div class="booking-card shadow-sm">
          <div class="booking-header bg-info text-white px-4 py-3 rounded-top">
            <h5 class="mb-0">Book an Appointment with a Counselor</h5>
          </div>
          <div class="booking-body bg-white p-4 rounded-bottom">
            <?php if ($message): ?>
              <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
            <?php endif; ?>
            <div class="table-responsive">
              <table class="booking-table table table-bordered align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>Counselor Name</th>
                    <th>Specialization</th>
                    <th>Select Date & Time</th>
                    <th>Reason</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($counselors as $counselor): ?>
                    <tr>
                      <form method="post" action="endpoint/book.php" onsubmit="return confirm('Are you sure you want to book this appointment?');">
                        <td><?= htmlspecialchars($counselor['name']) ?></td>
                        <td><?= htmlspecialchars($counselor['specialization']) ?></td>
                        <td>
                          <input type="datetime-local" name="time_slot" required class="form-control booking-input" />
                        </td>
                        <td>
                          <textarea name="reason" class="form-control booking-textarea" rows="2" placeholder="Reason for appointment" required></textarea>
                        </td>
                        <td>
                          <input type="hidden" name="counselor" value="<?= htmlspecialchars($counselor['name']) ?>" />
                          <input type="hidden" name="student_name" value="<?= htmlspecialchars($student_fullname) ?>" />
                          <input type="hidden" name="matric_id" value="<?= htmlspecialchars($student_matric_id) ?>" />
                          <input type="hidden" name="gender" value="<?= htmlspecialchars($student_gender) ?>" />
                          <button type="submit" class="btn btn-success btn-sm booking-btn">Book Now</button>
                        </td>
                      </form>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- My Appointments Section -->
    <section id="my-appointments-section" class="my-appt-section mt-5">
      <div class="container">
        <div class="appt-card shadow-sm">
          <div class="appt-header bg-info text-white px-4 py-3 rounded-top">
            <h5 class="mb-0">My Appointments</h5>
          </div>
          <div class="appt-body bg-white p-4 rounded-bottom">
            <?php if (count($appointments) > 0): ?>
              <div class="table-responsive">
                <table class="table my-appt-table table-striped align-middle mb-0">
                  <thead class="table-light">
                    <tr>
                      <th>Counselor</th>
                      <th>Time Slot</th>
                      <th>Status</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach ($appointments as $appt): ?>
                      <tr>
                        <td><?= htmlspecialchars($appt['counselor_name']) ?></td>
                        <td><?= htmlspecialchars($appt['time_slot']) ?></td>
                        <td>
                          <?php
                          $status = $appt['status'] ?? 'Booked';
                          $badgeClass = match (strtolower($status)) {
                            'approved' => 'success',
                            'rejected' => 'danger',
                            'booked', 'pending' => 'warning',
                            default => 'secondary'
                          };
                          ?>
                          <span class="badge bg-<?= $badgeClass ?>"><?= htmlspecialchars($status) ?></span>
                        </td>
                        <td>
                          <form method="post" onsubmit="return confirm('Are you sure you want to cancel this appointment?');">
                            <input type="hidden" name="cancel_student_name" value="<?= htmlspecialchars($appt['student_name']) ?>">
                            <input type="hidden" name="cancel_counselor_name" value="<?= htmlspecialchars($appt['counselor_name']) ?>">
                            <input type="hidden" name="cancel_time_slot" value="<?= htmlspecialchars($appt['time_slot']) ?>">
                            <button type="submit" class="btn btn-danger btn-sm my-appt-cancel-btn">Cancel</button>
                          </form>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
            <?php else: ?>
              <p class="text-muted mt-3">You have no booked appointments yet.</p>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </section>



  </main>
</body>

</html>