<?php
require '../conn/conn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get submitted values
    $type = $_POST['type'];
    $title = $_POST['title'];
    $description = $_POST['description'];
    $image_url = $_POST['image_url'];
    $link_url = $_POST['link_url'];
    $duration = $_POST['duration'];

    try {
        // Insert into resources table
        $stmt = $conn->prepare("INSERT INTO resources (type, title, description, image_url, link_url, duration, created_at) VALUES (?, ?, ?, ?, ?, ?, NOW())");
        $stmt->execute([$type, $title, $description, $image_url, $link_url, $duration]);

        // Redirect back with success flag
        header("Location: ../ManageResources.php?added=1");
        exit();
    } catch (PDOException $e) {
        // Redirect back with error flag
        header("Location: ../ManageResources.php?error=" . urlencode($e->getMessage()));
        exit();
    }
} else {
    // If accessed directly
    header("Location: ../ManageResources.php");
    exit();
}
