<?php
require '../conn/conn.php';

if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: ../ManageResources.php?error=missing_id");
    exit();
}

$id = $_GET['id'];

try {
    // Check if the resource exists
    $stmt = $conn->prepare("SELECT * FROM resources WHERE id = ?");
    $stmt->execute([$id]);
    $resource = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$resource) {
        header("Location: ../ManageResources.php?error=not_found");
        exit();
    }

    // Delete the resource
    $stmt = $conn->prepare("DELETE FROM resources WHERE id = ?");
    $stmt->execute([$id]);

    header("Location: ../ManageResources.php?deleted=1");
    exit();
} catch (PDOException $e) {
    header("Location: ../ManageResources.php?error=exception&msg=" . urlencode($e->getMessage()));
    exit();
}
