<?php
include('../conn/conn.php');
require '../vendor/autoload.php'; // PHPMailer autoload

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Get form data safely
$firstName = $_POST['first_name'] ?? '';
$lastName = $_POST['last_name'] ?? '';
$matricId = $_POST['matric_id'] ?? '';
$contactNumber = $_POST['contact_number'] ?? '';
$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';
$role = $_POST['role'] ?? '';
$gender = $_POST['gender'] ?? ''; // NEW: Get gender

try {
  // Check if user already exists by email OR matric_id
  $stmt = $conn->prepare("SELECT `email`, `matric_id` FROM `tbl_user` WHERE `email` = :email OR `matric_id` = :matric_id");
  $stmt->execute([
    'email' => $email,
    'matric_id' => $matricId
  ]);
  $userExist = $stmt->fetch(PDO::FETCH_ASSOC);

  if (empty($userExist)) {
    // Begin transaction
    $conn->beginTransaction();

    // Insert user data (with gender)
    $insertStmt = $conn->prepare("
            INSERT INTO `tbl_user` (`first_name`, `last_name`, `matric_id`, `contact_number`, `email`, `password`, `role`, `gender`)
            VALUES (:first_name, :last_name, :matric_id, :contact_number, :email, :password, :role, :gender)
        ");
    $insertStmt->bindParam(':first_name', $firstName, PDO::PARAM_STR);
    $insertStmt->bindParam(':last_name', $lastName, PDO::PARAM_STR);
    $insertStmt->bindParam(':matric_id', $matricId, PDO::PARAM_STR);
    $insertStmt->bindParam(':contact_number', $contactNumber, PDO::PARAM_STR);
    $insertStmt->bindParam(':email', $email, PDO::PARAM_STR);
    $insertStmt->bindParam(':password', $password, PDO::PARAM_STR); // Consider hashing in production
    $insertStmt->bindParam(':role', $role, PDO::PARAM_STR);
    $insertStmt->bindParam(':gender', $gender, PDO::PARAM_STR); // NEW: Bind gender
    $insertStmt->execute();

    // Commit transaction
    $conn->commit();

    // Send confirmation email
    $mail = new PHPMailer(true);
    try {
      $mail->isSMTP();
      $mail->Host       = 'smtp.gmail.com';
      $mail->SMTPAuth   = true;
      $mail->Username   = 'syaz1865@gmail.com';
      $mail->Password   = 'tnxibkgrkaetftew'; // Use app password
      $mail->SMTPSecure = 'tls';
      $mail->Port       = 587;

      $mail->setFrom('noreply@gmail.com', 'WellBot Team');

      if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $mail->addAddress($email, $firstName . ' ' . $lastName);
      } else {
        throw new Exception("Invalid recipient email address.");
      }

      // Email content
      $mail->isHTML(true);
      $mail->Subject = 'Pendaftaran Berjaya - WellBeing Platform';
      $mail->Body = '
<!DOCTYPE html>
<html lang="ms">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Welcome to WellBot</title>
</head>
<body style="margin:0; padding:0; font-family: Arial, sans-serif; background-color: #f5f7fa;">
  <table width="100%" bgcolor="#f5f7fa" cellpadding="0" cellspacing="0" border="0">
    <tr>
      <td align="center">
        <table width="600" bgcolor="#ffffff" cellpadding="20" cellspacing="0" border="0" style="border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1);">
          <tr>
            <td align="center" style="border-bottom: 3px solid #4CAF50; padding-bottom: 10px;">
              <h1 style="color: #4CAF50; margin: 0;">Unisel | WellBeing Platform</h1>
            </td>
          </tr>
          <tr>
            <td>
              <h2 style="color: #333333;">Selamat Datang, ' . htmlspecialchars($firstName) . '!</h2>
              <p style="color: #555555; font-size: 16px; line-height: 1.5;">
                Terima kasih kerana mendaftar di platform kami. Kami gembira anda menyertai komuniti WellBeing Unisel.
              </p>
              <p style="color: #555555; font-size: 16px; line-height: 1.5;">
                Anda kini boleh mula menggunakan sistem kami untuk mendapatkan manfaat sepenuhnya.
              </p>
              <p style="color: #555555; font-size: 16px; line-height: 1.5;">
                Jika anda mempunyai sebarang pertanyaan, jangan ragu untuk menghubungi kami di <a href="mailto:support@wellbot.com" style="color: #4CAF50;">support@wellbot.com</a>.
              </p>
              <p style="color: #555555; font-size: 16px; line-height: 1.5;">
                Terima kasih,<br>
                <strong>WellBeing Team</strong>
              </p>
              <hr style="border: none; border-top: 1px solid #eeeeee; margin: 20px 0;">
              <p style="color: #999999; font-size: 12px; text-align: center;">
                &copy; ' . date('Y') . ' WellBot. Hak cipta terpelihara.
              </p>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</body>
</html>
';

      $mail->send();
    } catch (Exception $e) {
      // Optional: log email errors silently
    }

    // Success message
    echo "
        <script>
            alert('Registered Successfully');
            window.location.href = 'http://localhost/Project/index.php';
        </script>
        ";
  } else {
    echo "
        <script>
            alert('Email or Matric ID already registered!');
            window.location.href = 'http://localhost/Project/index.php';
        </script>
        ";
  }
} catch (PDOException $e) {
  $conn->rollBack();
  echo "Error: " . $e->getMessage();
}
