<?php
include '../conn/conn.php'; // Connect to the database

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Retrieve and trim POST data
    $counselor = trim($_POST['counselor'] ?? '');
    $time_slot = trim($_POST['time_slot'] ?? '');
    $student_name = trim($_POST['student_name'] ?? '');
    $matric_id = trim($_POST['matric_id'] ?? '');
    $reason = trim($_POST['reason'] ?? '');
    $gender = trim($_POST['gender'] ?? '');

    // Basic validation: all fields required
    if ($counselor && $time_slot && $student_name && $matric_id && $reason && $gender) {
        try {
            // Check if the counselor already has an appointment at this time
            $checkStmt = $conn->prepare("SELECT COUNT(*) FROM appointments WHERE counselor_name = :counselor AND time_slot = :time_slot");
            $checkStmt->execute([
                ':counselor' => $counselor,
                ':time_slot' => $time_slot
            ]);
            $count = $checkStmt->fetchColumn();

            if ($count > 0) {
                echo "<script>
                    alert('This time slot has already been booked. Please choose a different time.');
                    window.location.href = '../appointment.php';
                </script>";
                exit();
            }

            // Insert new appointment with gender
            $stmt = $conn->prepare("INSERT INTO appointments (counselor_name, time_slot, student_name, matric_id, gender, reason, status) 
                                    VALUES (:counselor, :time_slot, :student_name, :matric_id, :gender, :reason, 'Pending')");
            $stmt->execute([
                ':counselor' => $counselor,
                ':time_slot' => $time_slot,
                ':student_name' => $student_name,
                ':matric_id' => $matric_id,
                ':gender' => $gender,
                ':reason' => $reason
            ]);

            echo "<script>
                alert('Appointment booked successfully!');
                window.location.href = '../appointment.php';
            </script>";
        } catch (PDOException $e) {
            echo "<script>
                alert('Booking failed: " . addslashes($e->getMessage()) . "');
                window.location.href = '../appointment.php';
            </script>";
        }
    } else {
        echo "<script>
            alert('Missing required information.');
            window.location.href = '../appointment.php';
        </script>";
    }
} else {
    // Redirect if accessed without POST
    header("Location: ../appointment.php");
    exit();
}
