<?php
session_start();
include('../conn/conn.php'); // Adjust path if needed
header('Content-Type: application/json');

// Ensure user is logged in
if (!isset($_SESSION['email'])) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'User not logged in']);
    exit();
}

// Get POST data
$data = json_decode(file_get_contents("php://input"), true);

$email = $_SESSION['email'];
$mood = $data['mood'] ?? '';
$note = $data['suggestion'] ?? ''; // JS sends it as 'suggestion'

// Validate mood
if (empty($mood)) {
    echo json_encode(['status' => 'error', 'message' => 'Mood is required']);
    exit();
}

try {
    // Insert mood into daily_mood table
    $stmt = $conn->prepare("INSERT INTO daily_mood (email, mood, note) VALUES (:email, :mood, :note)");
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':mood', $mood);
    $stmt->bindParam(':note', $note);
    $stmt->execute();

    echo json_encode(['status' => 'success', 'message' => 'Mood saved successfully']);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

