<?php
include('../conn/conn.php');  // $conn variable is created here

if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = intval($_GET['id']);

    // First get the appointment info to extract student_name
    $stmt = $conn->prepare("SELECT * FROM appointments WHERE id = ?");
    $stmt->execute([$id]);
    $appointment = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($appointment) {
        // Split student_name into first_name and last_name
        $nameParts = explode(' ', trim($appointment['student_name']));
        $first_name = $nameParts[0];
        $last_name = isset($nameParts[1]) ? $nameParts[1] : '';

        // Now query appointments + matric_id joined on first_name and last_name
        $stmt2 = $conn->prepare("
            SELECT a.*, u.matric_id
            FROM appointments a
            LEFT JOIN tbl_user u ON u.first_name = :first_name AND u.last_name = :last_name
            WHERE a.id = :id
        ");
        $stmt2->bindParam(':first_name', $first_name);
        $stmt2->bindParam(':last_name', $last_name);
        $stmt2->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt2->execute();
        $appointmentWithMatric = $stmt2->fetch(PDO::FETCH_ASSOC);

        $matric_id = $appointmentWithMatric['matric_id'] ?? 'N/A';
?>
        <!DOCTYPE html>
        <html lang="en">

        <head>
            <meta charset="UTF-8" />
            <meta name="viewport" content="width=device-width, initial-scale=1" />
            <title>University of Selangor Counseling Report</title>
            <link rel="icon" href="images/logo.png" type="image/png">

            <style>
                /* Reset some */
                * {
                    box-sizing: border-box;
                }

                body {
                    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                    margin: 40px auto;
                    max-width: 800px;
                    background-color: #fff8f0;
                    color: #663300;
                    line-height: 1.6;
                }

                header {
                    border-bottom: 3px solid #ff6600;
                    padding-bottom: 15px;
                    margin-bottom: 30px;
                    display: flex;
                    align-items: center;
                    gap: 15px;
                }

                header img {
                    height: 70px;
                    object-fit: contain;
                }

                header .university-info {
                    flex-grow: 1;
                }

                header h1 {
                    font-size: 1.8rem;
                    margin: 0;
                    color: #ff6600;
                }

                header p {
                    margin: 2px 0 0 0;
                    font-size: 0.9rem;
                    color: #cc5200;
                }

                .report-title {
                    text-align: center;
                    font-size: 1.5rem;
                    font-weight: 700;
                    margin-bottom: 30px;
                    color: #ff6600;
                    text-transform: uppercase;
                    letter-spacing: 1.2px;
                }

                table {
                    width: 100%;
                    border-collapse: collapse;
                    margin-bottom: 40px;
                }

                table td {
                    padding: 12px 10px;
                    vertical-align: top;
                    border: 1px solid #ffcc99;
                }

                table td.label {
                    font-weight: 600;
                    background-color: #fff0e6;
                    width: 30%;
                    color: #cc5200;
                }

                .notes {
                    white-space: pre-wrap;
                    font-style: italic;
                    background-color: #fff3e6;
                    border: 1px solid #ffcc99;
                    padding: 15px;
                    border-radius: 5px;
                    margin-top: -1px;
                    color: #663300;
                }

                footer {
                    border-top: 3px solid #ff6600;
                    padding-top: 10px;
                    font-size: 0.9rem;
                    color: #cc5200;
                    text-align: right;
                    font-style: italic;
                }

                /* Print button */
                .print-btn {
                    background-color: #ff6600;
                    color: #fff;
                    padding: 10px 18px;
                    border: none;
                    border-radius: 5px;
                    cursor: pointer;
                    font-size: 1rem;
                    margin-bottom: 30px;
                    transition: background-color 0.3s ease;
                }

                .print-btn:hover {
                    background-color: #cc5200;
                }

                @media print {
                    .print-btn {
                        display: none;
                    }

                    body {
                        margin: 0;
                        max-width: none;
                    }

                    footer {
                        position: fixed;
                        bottom: 0;
                        width: 100%;
                        background: white;
                    }
                }
            </style>
            <script>
                function printReport() {
                    window.print();
                }
            </script>
        </head>

        <body>
            <header>
                <img src="../images/unisel.png" alt="University of Selangor Logo" />
                <div class="university-info">
                    <h1>University of Selangor</h1>
                    <p>Faculty of Counseling & Psychological Services</p>
                    <p>Official Student Counseling Report</p>
                </div>
            </header>

            <button class="print-btn" onclick="printReport()">🖨️ Print Report</button>

            <div class="report-title">Student Counseling Report</div>

            <table>
                <tr>
                    <td class="label">Student Name</td>
                    <td><?= htmlspecialchars($appointmentWithMatric['student_name']) ?></td>
                </tr>
                <tr>
                    <td class="label">Matric ID</td>
                    <td><?= htmlspecialchars($matric_id) ?></td>
                </tr>
                <tr>
                    <td class="label">Counselor Name</td>
                    <td><?= htmlspecialchars($appointmentWithMatric['counselor_name']) ?></td>
                </tr>
                <tr>
                    <td class="label">Date & Time</td>
                    <td><?= date("F d, Y - h:i A", strtotime($appointmentWithMatric['time_slot'])) ?></td>
                </tr>
                <tr>
                    <td class="label">Status</td>
                    <td><?= ucfirst(htmlspecialchars($appointmentWithMatric['status'])) ?></td>
                </tr>
                <tr>
                    <td class="label">Reason for Counseling</td>
                    <td><?= htmlspecialchars($appointmentWithMatric['reason']) ?></td>
                </tr>
                <tr>
                    <td class="label">Counselor Notes</td>
                    <td>
                        <div class="notes"><?= nl2br(htmlspecialchars($appointmentWithMatric['counselor_notes'])) ?></div>
                    </td>
                </tr>
            </table>

            <footer>
                Generated on <?= date("F d, Y") ?> | University of Selangor Counseling Department
            </footer>
        </body>

        </html>

<?php
    } else {
        echo "<p style='color:red; text-align:center;'>Report not found.</p>";
    }
} else {
    echo "<p style='color:red; text-align:center;'>Invalid request. No ID provided.</p>";
}
?>