<?php
session_start();
include('../conn/conn.php');

if (!isset($_SESSION['email'])) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'User not logged in']);
    exit();
}

$email = $_SESSION['email'];

try {
    $stmt = $conn->prepare("
        SELECT mood, COUNT(*) as count 
        FROM quiz_results 
        WHERE email = :email 
        AND MONTH(created_at) = MONTH(CURRENT_DATE)
        AND YEAR(created_at) = YEAR(CURRENT_DATE)
        GROUP BY mood
    ");
    $stmt->bindParam(':email', $email);
    $stmt->execute();
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($results);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
