<?php
session_start();
include('../conn/conn.php'); // Adjust path if needed

if (!isset($_SESSION['email'])) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'User not logged in']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);

$email = $_SESSION['email'];
$score = $data['score'] ?? null;
$mood = $data['mood'] ?? '';
$suggestion = $data['suggestion'] ?? '';

try {
    $stmt = $conn->prepare("INSERT INTO quiz_results (email, score, mood, suggestion) VALUES (:email, :score, :mood, :suggestion)");
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':score', $score);
    $stmt->bindParam(':mood', $mood);
    $stmt->bindParam(':suggestion', $suggestion);
    $stmt->execute();

    echo json_encode(['status' => 'success', 'message' => 'Result saved']);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

