<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
include('conn/conn.php');

$email = $_SESSION['email'] ?? '';
if (!$email) {
    echo "User not logged in.";
    exit;
}

// Fetch all unique dates user logged mood, sorted DESC
$stmt = $conn->prepare("
    SELECT DISTINCT DATE(created_at) AS log_date
    FROM daily_mood
    WHERE email = :email
    ORDER BY log_date DESC
");
$stmt->bindParam(':email', $email);
$stmt->execute();
$dates = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Prepare data for 7-day activity chart
$activity = [];
$logDates = array_map(fn($d) => (new DateTime($d))->format('Y-m-d'), $dates);

for ($i = 6; $i >= 0; $i--) {
    $day = (new DateTime())->modify("-$i days")->format('Y-m-d');
    $activity[] = in_array($day, $logDates) ? 1 : 0;
}

// Count days logged vs not logged in past 7 days
$logged = array_sum($activity);
$notLogged = 7 - $logged;

// Output only the donut chart section
echo "
<div style='background-color: #f0f4ff; border-radius: 1rem; padding: 1rem; margin-top: 1rem; box-shadow: 0 4px 10px rgba(0,0,0,0.04);'>
    <h6 class='text-muted text-center'>🗓️ Mood Activity (Last 7 Days)</h6>
    <div style='max-width: 220px; margin: 0 auto; position: relative;'>
        <canvas id='streakPieChart'></canvas>
        <div style='position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);
                    font-weight: 600; font-size: 1rem; color: #333;'>$logged / 7</div>
    </div>
</div>

<script src='https://cdn.jsdelivr.net/npm/chart.js'></script>
<script>
    const pieCtx = document.getElementById('streakPieChart').getContext('2d');
    new Chart(pieCtx, {
        type: 'doughnut',
        data: {
            labels: ['Logged', 'Not Logged'],
            datasets: [{
                data: [$logged, $notLogged],
                backgroundColor: ['#198754', '#dc3545'],
                hoverBackgroundColor: ['#157347', '#c82333'],
                borderWidth: 2
            }]
        },
        options: {
            cutout: '60%',
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        font: {
                            size: 12
                        },
                        color: '#333'
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.label + ': ' + context.raw + ' day(s)';
                        }
                    }
                }
            }
        }
    });
</script>";
