<?php
include('../conn/conn.php');

$counselorID = $_POST['id'];
$name = $_POST['name'];
$password = $_POST['CounselorPassword']; // Leave blank to retain current password
$email = $_POST['email'];
$phone = $_POST['phone'];
$specialization = $_POST['specialization'];

try {
    $conn->beginTransaction();

    // Fetch current counselor (to retain existing password or image if unchanged)
    $stmt = $conn->prepare("SELECT CounselorPassword, profile_image FROM counselors WHERE id = ?");
    $stmt->execute([$counselorID]);
    $currentData = $stmt->fetch(PDO::FETCH_ASSOC);

    // Use existing password if field is empty
    if (empty($password)) {
        $password = $currentData['CounselorPassword'];
    }

    // Handle new image upload
    $newImageName = $currentData['profile_image']; // default to existing
    if (!empty($_FILES['profile_image']['name'])) {
        $targetDir = "../uploads/";
        $newImageName = time() . '_' . basename($_FILES['profile_image']['name']);
        $targetPath = $targetDir . $newImageName;

        if (!is_dir($targetDir)) {
            mkdir($targetDir, 0755, true);
        }

        move_uploaded_file($_FILES['profile_image']['tmp_name'], $targetPath);
    }

    // Update the counselor record
    $stmt = $conn->prepare("
        UPDATE `counselors` SET 
            `name` = :name,
            `CounselorPassword` = :password,
            `email` = :email,
            `phone` = :phone,
            `specialization` = :specialization,
            `profile_image` = :profile_image
        WHERE `id` = :id
    ");

    $stmt->execute([
        ':name' => $name,
        ':password' => $password,
        ':email' => $email,
        ':phone' => $phone,
        ':specialization' => $specialization,
        ':profile_image' => $newImageName,
        ':id' => $counselorID
    ]);

    $conn->commit();

    echo "<script>
        alert('Counselor updated successfully.');
        window.location.href = 'http://localhost/Project/ManageCounselor.php';
    </script>";
} catch (PDOException $e) {
    $conn->rollBack();
    echo "Error: " . $e->getMessage();
}
