<?php
include('../conn/conn.php');

$updateUserID = $_POST['tbl_user_id'];
$updateFirstName = $_POST['first_name'];
$updateLastName = $_POST['last_name'];
$updateContactNumber = $_POST['contact_number'];
$updateEmail = $_POST['email'];
$updatePassword = $_POST['password'];
$updateRole = $_POST['role'];

try {
    // Check if same name exists for a different user
    $stmt = $conn->prepare("
        SELECT `tbl_user_id` 
        FROM `tbl_user` 
        WHERE `first_name` = :first_name 
          AND `last_name` = :last_name 
          AND `tbl_user_id` != :userID
    ");
    $stmt->execute([
        'first_name' => $updateFirstName,
        'last_name' => $updateLastName,
        'userID' => $updateUserID
    ]);
    $nameExist = $stmt->fetch(PDO::FETCH_ASSOC);

    if (empty($nameExist)) {
        $conn->beginTransaction();

        $updateStmt = $conn->prepare("
            UPDATE `tbl_user` SET 
                `first_name` = :first_name, 
                `last_name` = :last_name, 
                `contact_number` = :contact_number, 
                `email` = :email, 
                `password` = :password,
                `role` = :role
            WHERE `tbl_user_id` = :userID
        ");

        $updateStmt->bindParam(':first_name', $updateFirstName, PDO::PARAM_STR);
        $updateStmt->bindParam(':last_name', $updateLastName, PDO::PARAM_STR);
        $updateStmt->bindParam(':contact_number', $updateContactNumber, PDO::PARAM_STR);
        $updateStmt->bindParam(':email', $updateEmail, PDO::PARAM_STR);
        $updateStmt->bindParam(':password', $updatePassword, PDO::PARAM_STR); // consider password_hash()
        $updateStmt->bindParam(':role', $updateRole, PDO::PARAM_STR);
        $updateStmt->bindParam(':userID', $updateUserID, PDO::PARAM_INT);

        $updateStmt->execute();
        $conn->commit();

        echo "
        <script>
            alert('Updated Successfully');
            window.location.href = 'http://localhost/Project/admin.php';
        </script>
        ";
    } else {
        echo "
        <script>
            alert('User Already Exists');
            window.location.href = 'http://localhost/Project/admin.php';
        </script>
        ";
    }
} catch (PDOException $e) {
    $conn->rollBack();
    echo "Error: " . $e->getMessage();
}
