<?php
session_start();
require '../conn/conn.php';

if (!isset($_SESSION['email'])) {
    header("Location: ../index.php");
    exit();
}

$email = $_SESSION['email'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first = $_POST['first_name'];
    $last = $_POST['last_name'];
    $contact = $_POST['contact_number'];
    $gender = $_POST['gender'];
    $new_email = $_POST['email'];

    // Default to current profile image
    $stmt = $conn->prepare("SELECT profile_image FROM tbl_user WHERE email = ?");
    $stmt->execute([$email]);
    $existing = $stmt->fetch(PDO::FETCH_ASSOC);
    $profile_image = $existing['profile_image'];

    // Handle new profile image upload
    if (isset($_FILES['profile_image']) && $_FILES['profile_image']['error'] === 0) {
        $uploadDir = "../uploads/";
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        $filename = uniqid() . "_" . basename($_FILES['profile_image']['name']);
        $targetPath = $uploadDir . $filename;

        if (move_uploaded_file($_FILES['profile_image']['tmp_name'], $targetPath)) {
            $profile_image = $filename;
        }
    }

    try {
        $stmt = $conn->prepare("UPDATE tbl_user 
            SET first_name = :first, last_name = :last, contact_number = :contact, gender = :gender, email = :new_email, profile_image = :profile_image 
            WHERE email = :email");
        $stmt->execute([
            ':first' => $first,
            ':last' => $last,
            ':contact' => $contact,
            ':gender' => $gender,
            ':new_email' => $new_email,
            ':profile_image' => $profile_image,
            ':email' => $email
        ]);

        // Update session if email changed
        $_SESSION['email'] = $new_email;

        header("Location: ../UserProfile.php?update=success");
        exit();
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}
