<?php
session_start();
require '../conn/conn.php'; // Adjust if needed

header('Content-Type: application/json');

// Check session
if (!isset($_SESSION['email'])) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'User not logged in']);
    exit();
}

$email = $_SESSION['email'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['profile_image'])) {
    $file = $_FILES['profile_image'];
    $uploadDir = "../uploads/";

    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    $filename = uniqid() . "_" . basename($file['name']);
    $targetPath = $uploadDir . $filename;

    if (move_uploaded_file($file['tmp_name'], $targetPath)) {
        try {
            $stmt = $conn->prepare("UPDATE tbl_user SET profile_image = :profile_image WHERE email = :email");
            $stmt->bindParam(':profile_image', $filename);
            $stmt->bindParam(':email', $email);
            $stmt->execute();

            echo json_encode(['status' => 'success', 'message' => 'Profile image updated', 'filename' => $filename]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
    } else {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Failed to upload image']);
    }

}
