<?php include('./conn/conn.php'); ?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Registration and Login System</title>

    <!-- Style CSS -->
    <link rel="stylesheet" href="./css/login.css">
    <link rel="stylesheet" href="css/responsive.css" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>

<body>

    <nav class="navbar navbar-expand-lg navbar-light bg-light">
        <a class="navbar-brand ml-5" href="home.php">User Registration and Login System</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarScroll">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarScroll">
            <ul class="navbar-nav mr-auto" style="margin-left: auto;">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown">My Account</a>
                    <div class="dropdown-menu">
                        <a class="dropdown-item" href="index.php">Log Out</a>
                    </div>
                </li>
            </ul>
        </div>
    </nav>

    <!-- Update Modal -->
    <div class="modal fade mt-5" id="updateUserModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Update User</h5>
                    <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                </div>
                <div class="modal-body">
                    <form action="./endpoint/update-user.php" method="POST">
                        <input type="hidden" name="tbl_user_id" id="updateUserID">
                        <div class="form-group row">
                            <div class="col-6">
                                <label for="updateFirstName">First Name:</label>
                                <input type="text" class="form-control" id="updateFirstName" name="first_name">
                            </div>
                            <div class="col-6">
                                <label for="updateLastName">Last Name:</label>
                                <input type="text" class="form-control" id="updateLastName" name="last_name">
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-5">
                                <label for="updateContactNumber">Contact Number:</label>
                                <input type="number" class="form-control" id="updateContactNumber" name="contact_number">
                            </div>
                            <div class="col-7">
                                <label for="updateEmail">Email:</label>
                                <input type="text" class="form-control" id="updateEmail" name="email">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="updateUsername">Username:</label>
                            <input type="text" class="form-control" id="updateUsername" name="username">
                        </div>
                        <div class="form-group">
                            <label for="updatePassword">Password:</label>
                            <input type="text" class="form-control" id="updatePassword" name="password">
                        </div>
                        <div class="form-group">
                            <label for="updateRole">Role:</label>
                            <select class="form-control" id="updateRole" name="role">
                                <option value="User">User</option>
                                <option value="Admin">Admin</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-dark form-control">Update</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="content">
            <h4>List of users</h4>
            <hr>
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>User ID</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Contact Number</th>
                        <th>Email</th>
                        <th>Username</th>
                        <th>Password</th>
                        <th>Role</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $stmt = $conn->prepare("SELECT * FROM `tbl_user`");
                    $stmt->execute();
                    $result = $stmt->fetchAll();

                    foreach ($result as $row):
                        $userID = $row['tbl_user_id'];
                    ?>
                        <tr>
                            <td id="userID-<?= $userID ?>"><?= $row['tbl_user_id'] ?></td>
                            <td id="firstName-<?= $userID ?>"><?= $row['first_name'] ?></td>
                            <td id="lastName-<?= $userID ?>"><?= $row['last_name'] ?></td>
                            <td id="contactNumber-<?= $userID ?>"><?= $row['contact_number'] ?></td>
                            <td id="email-<?= $userID ?>"><?= $row['email'] ?></td>
                            <td id="username-<?= $userID ?>"><?= $row['username'] ?></td>
                            <td id="password-<?= $userID ?>"><?= $row['password'] ?></td>
                            <td id="role-<?= $userID ?>"><?= $row['role'] ?></td>
                            <td>
                                <button onclick="update_user(<?= $userID ?>)">✏️</button>
                                <button onclick="delete_user(<?= $userID ?>)">🗑️</button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <script>
        function update_user(id) {
            $("#updateUserModal").modal("show");

            $("#updateUserID").val($("#userID-" + id).text());
            $("#updateFirstName").val($("#firstName-" + id).text());
            $("#updateLastName").val($("#lastName-" + id).text());
            $("#updateContactNumber").val($("#contactNumber-" + id).text());
            $("#updateEmail").val($("#email-" + id).text());
            $("#updateUsername").val($("#username-" + id).text());
            $("#updatePassword").val($("#password-" + id).text());
            $("#updateRole").val($("#role-" + id).text());
        }

        function delete_user(id) {
            if (confirm("Do you want to delete this user?")) {
                window.location = "./endpoint/delete-user.php?user=" + id;
            }
        }
    </script>

    <!-- Bootstrap Js -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js"></script>
</body>

</html>