<?php include('./conn/conn.php') ?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Registration and Login System</title>

    <!-- Style CSS -->
    <link rel="stylesheet" href="css/indexlogin.css">
    <link rel="icon" href="images/logo.png" type="image/png">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">


    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>

<body>

    <div class="main">

        <!-- Login Area -->
        <div class="login" id="loginForm">
            <h1 class="text-center">Login Form</h1>
            <div class="login-form">
                <form action="./endpoint/login.php" method="POST">
                    <div class="form-group">
                        <label for="loginEmail">Email:</label>
                        <input type="email" class="form-control" id="loginEmail" name="email" required>
                    </div>

                    <div class="form-group">
                        <label for="password">Password:</label>
                        <input type="password" class="form-control" id="password" name="password" required>
                    </div>
                    <p class="registrationForm" onclick="showRegistrationForm()">No Account? Register Here.</p>
                    <button type="submit" class="btn btn-dark login-btn form-control">Login</button>
                </form>
            </div>
        </div>

        <!-- Registration Area -->
        <div class="registration" id="registrationForm" style="display:none;">
            <h1 class="text-center">Registration Form</h1>
            <form action="./endpoint/add-user.php" method="POST" class="registration-form">

                <div class="form-group row">
                    <div class="col-6">
                        <label for="firstName">First Name:</label>
                        <input type="text" class="form-control" id="firstName" name="first_name" required>
                    </div>
                    <div class="col-6">
                        <label for="lastName">Last Name:</label>
                        <input type="text" class="form-control" id="lastName" name="last_name" required>
                    </div>
                </div>

                <div class="form-group">
                    <label for="matricId">Matric ID:</label>
                    <input type="text" class="form-control" id="matricId" name="matric_id" placeholder="e.g., 3232123456" required>
                </div>

                <div class="form-group row">
                    <div class="col-5">
                        <label for="contactNumber">Contact Number:</label>
                        <input type="number" class="form-control" id="contactNumber" name="contact_number" maxlength="11" required>
                    </div>
                    <div class="col-7">
                        <label for="registerEmail">Email:</label>
                        <input type="email" class="form-control" id="registerEmail" name="email" required>
                    </div>
                </div>

                <div class="form-group">
                    <label>Gender:</label><br>
                    <label class="form-check-inline">
                        <input type="radio" name="gender" value="male" required> Male
                    </label>
                    <label class="form-check-inline">
                        <input type="radio" name="gender" value="female"> Female
                    </label>
                </div>

                <div class="form-group">
                    <label for="registerPassword">Password:</label>
                    <input type="password" class="form-control" id="registerPassword" name="password" required>
                </div>

                <div class="form-group">
                    <label for="registerRole">Role:</label>
                    <select class="form-control" id="registerRole" name="role" required>
                        <option value="">Select Role</option>
                        <option value="student">Student</option>
                        <option value="parent">Parent</option>
                        <option value="others">Others</option>
                    </select>
                </div>

                <p class="registrationForm" onclick="showLoginForm()">&larr; Back</p>
                <button type="submit" class="btn btn-dark login-register form-control">Register</button>
            </form>
        </div>


    </div>

    <script>
        // Constant variables
        const loginForm = document.getElementById('loginForm');
        const registrationForm = document.getElementById('registrationForm');

        // Hide registration form
        registrationForm.style.display = "none";


        function showRegistrationForm() {
            registrationForm.style.display = "";
            loginForm.style.display = "none";
        }

        function showLoginForm() {
            registrationForm.style.display = "none";
            loginForm.style.display = "";
        }
    </script>



</body>

</html>