<?php
session_start();
include('conn/conn.php'); // ✅ make sure this path is correct


// Check if user is logged in
if (!isset($_SESSION['email'])) {
  header("Location: index.php");
  exit();
}

$email = $_SESSION['email'];

// Fetch user's first name and profile image
try {
  $stmt = $conn->prepare("SELECT first_name, profile_image FROM tbl_user WHERE email = ?");
  $stmt->execute([$email]);
  $user = $stmt->fetch(PDO::FETCH_ASSOC);

  $imagePath = (!empty($user['profile_image']) && file_exists("uploads/" . $user['profile_image']))
    ? "uploads/" . $user['profile_image']
    : "images/default-profile.jpg"; // fallback
} catch (PDOException $e) {
  $user = ['first_name' => 'Guest'];
  $imagePath = "images/default-profile.jpg";
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>WellBeing | User Dashboard</title>

  <link
    href="https://fonts.googleapis.com/css2?family=Montserrat&family=Ubuntu&display=swap"
    rel="stylesheet" />
  <link
    href="https://fonts.googleapis.com/css2?family=Satisfy&display=swap"
    rel="stylesheet" />

  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link
    href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
    rel="stylesheet" />
  <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
    integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
    crossorigin="anonymous"
    referrerpolicy="no-referrer" />
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

  <!-- Bootstrap CSS -->
  <link
    href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
    rel="stylesheet" />
  <!-- Font Awesome -->
  <link
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
    rel="stylesheet" />

  <link rel="stylesheet" href="css/session.css" />
  <link rel="stylesheet" href="css/responsive.css" />
  <link rel="icon" href="images/logo.png" type="image/png">

</head>

<body>
  <!-- Sidebar -->
  <aside id="sidebar" aria-label="Sidebar Navigation">
    <div class="logo" aria-label="Logo">
      <img src="images/logo.png" alt="logo" class="logo-img" />
      <span class="logo-text"> WELLBEING </span>
    </div>
    <nav>
      <ul>
        <li>
          <a href="User.php" class="with-badge">
            <i class="fas fa-tachometer-alt mr-2"></i>
            <span class="text">Dashboard</span>
          </a>
        </li>
        <li>
          <a href="Resources.php" class="with-badge">
            <i class="fas fa-th-large mr-2"></i>
            <span class="text"> Resources</span>
          </a>
        </li>
        <li>
          <a href="appointment.php" class="with-badge">
            <i class="fas fa-book mr-2"></i>
            <span class="text"> Appointment</span>
          </a>
        </li>
        <li>
          <a href="session.php" class="active">
            <i class="fas fa-calendar-check mr-2"></i>
            <span class="text"> Session</span>
          </a>
        </li>
        <li>
          <a href="Forum.php" class="with-badge">
            <i class="fas fa-comments mr-2"></i>
            <span class="text"> Student Space</span>
          </a>

        </li>
        <li>
          <a href="UserProfile.php" class="with-badge">
            <i class="fas fa-edit mr-2"></i>
            <span class="text"> Profile</span>
          </a>

        </li>
        <li class="menu-item-collapsible">
          <a
            href="javascript:void(0);"
            class="d-flex align-items-center justify-content-between submenu-toggle">
            <span><i class="fas fa-layer-group mr-2"></i><span class="text"> Menu Levels</span></span>
            <i class="fas fa-angle-right menu-arrow"></i>
          </a>
          <ul class="submenu list-unstyled">
            <li><a href="#">Level 1</a></li>
            <li><a href="#">Level 2</a></li>
            <li><a href="#">Level 3</a></li>
          </ul>
        </li>
      </ul>
    </nav>
  </aside>

  <!-- Top Navigation -->
  <header id="topnav" role="banner" aria-label="Top Navigation Bar">
    <div id="search-bar" aria-label="Site Search">
      <input type="search" aria-label="Search" placeholder="Search..." />
      <i class="fas fa-search"></i>
    </div>

    <div class="nav-icons">
      <i
        class="fas fa-bell"
        aria-label="Notifications"
        title="Notifications"
        tabindex="0"></i>
      <div class="user-profile" tabindex="0" aria-label="User Profile">
        <span class="greeting">Hi, <?= htmlspecialchars($user['first_name']) ?></span>
        <a href="UserProfile.php">
          <img src="<?= htmlspecialchars($imagePath) ?>" alt="User Profile Picture"
            class="rounded-circle" style="width: 40px; height: 40px; object-fit: cover;">
        </a>
      </div>

    </div>
  </header>

  <main id="main-content" role="main">

    <section class="container mt-5">
      <div class="card">
        <div class="card-header bg-info text-white">
          <h5 class="mb-0">Available Counseling Sessions</h5>
        </div>
        <div class="card-body">
          <table class="table table-bordered table-striped mb-0">
            <thead>
              <tr>
                <th>Counselor Name</th>
                <th>Time Slot</th>
                <th>Join</th>
              </tr>
            </thead>
            <tbody>
              <?php
              $stmt = $conn->prepare("SELECT * FROM sessions ORDER BY time_slot ASC");
              $stmt->execute();
              $sessions = $stmt->fetchAll();

              if (count($sessions) > 0):
                foreach ($sessions as $session):
              ?>
                  <tr>
                    <td><?= htmlspecialchars($session['counselor_name']) ?></td>
                    <td><?= date("F j, Y, g:i A", strtotime($session['time_slot'])) ?></td>
                    <td>
                      <a href="<?= htmlspecialchars($session['meeting_link']) ?>" target="_blank" class="btn btn-success btn-sm">
                        Join
                      </a>
                    </td>
                  </tr>
              <?php
                endforeach;
              else:
                echo "<tr><td colspan='3'>No upcoming sessions available.</td></tr>";
              endif;
              ?>
            </tbody>
          </table>
        </div>
      </div>
    </section>


  </main>

</body>

</html>