<?php
session_start();
include('conn/conn.php'); // Ensure this connects to your DB

// Redirect if not logged in
if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit();
}

$student_username = $_SESSION['username'];

// Fetch the latest quote from tbl_quote table
$quoteQuery = $conn->query("SELECT * FROM tbl_quote ORDER BY id DESC LIMIT 1");
$quote = $quoteQuery->fetch();

// Get appointment count for the logged-in user
$countStmt = $conn->prepare("SELECT COUNT(*) FROM appointments WHERE student_name = :student_name");
$countStmt->bindParam(':student_name', $student_username, PDO::PARAM_STR);
$countStmt->execute();
$appointment_count = $countStmt->fetchColumn();

$countStmt = $conn->prepare("SELECT COUNT(*) FROM sessions");
$countStmt->execute();
$session_count = $countStmt->fetchColumn();

?>





<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>WellBeing | User Dashboard</title>

    <link href="https://fonts.googleapis.com/css2?family=Montserrat&family=Ubuntu&display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Satisfy&display=swap" rel="stylesheet" />

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet" />

    <link rel="stylesheet" href="css/UserDashboard.css" />
    <link rel="icon" href="images/logo.png" type="image/png">
</head>

<body>

    <!-- Sidebar -->
    <aside id="sidebar" aria-label="Sidebar Navigation">
        <div class="logo" aria-label="Logo">
            <img src="images/logo.png" alt="logo" class="logo-img">
            <span class="logo-text"> WELLBEING </span>
        </div>
        <nav>
            <ul>
                <li>
                    <a href="#" class="active">
                        <i class="fas fa-tachometer-alt mr-2"></i> <span class="text">Dashboard</span>
                    </a>
                </li>
                <li>
                    <a href="Resources.html" class="with-badge">
                        <i class="fas fa-th-large mr-2"></i>
                        <span class="text"> Resources</span>
                        <span class="badge-green badge">4</span>
                    </a>
                </li>
                <li>
                    <a href="appointment.php" class="with-badge">
                        <i class="fas fa-book mr-2"></i>
                        <span class="text"> Appointment</span>
                        <span class="badge-purple badge">8</span>
                    </a>

                </li>
                <li>
                    <a href="session.php" class="with-badge">
                        <i class="fas fa-calendar-check mr-2"></i>
                        <span class="text"> Session</span>
                        <span class="badge-purple badge">8</span>
                    </a>

                </li>
                <li class="menu-item-collapsible">
                    <a href="javascript:void(0);" class="d-flex align-items-center justify-content-between submenu-toggle">
                        <span><i class="fas fa-layer-group mr-2"></i><span class="text"> Menu Levels</span></span>
                        <i class="fas fa-angle-right menu-arrow"></i>
                    </a>
                    <ul class="submenu list-unstyled">
                        <li><a href="#">Level 1</a></li>
                        <li><a href="#">Level 2</a></li>
                        <li><a href="#">Level 3</a></li>
                    </ul>
                </li>
            </ul>
        </nav>
    </aside>

    <!-- Top Navigation -->
    <header id="topnav" role="banner" aria-label="Top Navigation Bar">
        <div id="search-bar" aria-label="Site Search">
            <input type="search" aria-label="Search" placeholder="Search...">
            <i class="fas fa-search"></i>
        </div>

        <div class="nav-icons">
            <i class="fas fa-bell" aria-label="Notifications" title="Notifications" tabindex="0"></i>
            <div class="user-profile" tabindex="0" aria-label="User Profile">
                <span class="greeting">Hi, Syazwi</span>
                <img src="images/awi .jpg" alt="User Profile Picture" />
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main id="main-content" role="main">
        <section id="welcome-section">
            <h2>Hi, Welcome <?php echo htmlspecialchars($_SESSION['username']); ?></h2>
            <p>Manage Your Mental Health Here!</p>
        </section>


        <div id="main-grid">
            <section id="left-content">



                <div class="button-row" aria-label="Dashboard Buttons">
                    <button id="mood-button" class="metric-button btn-blue" type="button" aria-label="Mood Good Button">Mood: Good</button>
                    <button class="metric-button btn-danger" type="button" aria-label="Appointment <?= htmlspecialchars($appointment_count) ?> Button" onclick="window.location.href='appointment.php';">
                        Appointment: <?= htmlspecialchars($appointment_count) ?>
                    </button>


                    <button class="metric-button btn-green" type="button" aria-label="Session <?= htmlspecialchars($session_count) ?> Button">
                        Session: <?= htmlspecialchars($session_count) ?>
                    </button>


                </div>




                <section id="stats-mood" aria-label="User Statistics Mood">
                    <div class="header">
                        <h3>User Statistics Mood</h3>
                        <div class="btn-group" role="group" aria-label="Export and Print buttons">
                            <button type="button" class="btn btn-outline-primary btn-sm" title="Export">
                                <i class="fas fa-file-export"></i> Export
                            </button>
                            <button type="button" class="btn btn-outline-secondary btn-sm" title="Print">
                                <i class="fas fa-print"></i> Print
                            </button>
                        </div>
                    </div>


                    <div class="chart-card-container">
                        <div class="card graph">
                            <div class="graph-body">
                                <!-- Mood History Display -->
                                <div class="history">
                                    <ul id="mood-history"></ul>
                                </div>
                                <!-- Chart Section -->
                                <div class="chart-wrapper">
                                    <canvas id="mood-chart" width="400" height="180"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                </section>


                <div class="card select-your-mood-div">
                    <form id="mood-form">
                        <label for="mood">Select your current mood:</label>
                        <select id="mood" required>
                            <option value="">--Choose Mood--</option>
                            <option value="Happy">😊 Happy</option>
                            <option value="Sad">😢 Sad</option>
                            <option value="Anxious">😟 Anxious</option>
                            <option value="Excited">🤩 Excited</option>
                            <option value="Angry">😡 Angry</option>
                            <option value="Relaxed">😌 Relaxed</option>
                        </select>
                        <button type="submit">Save Mood</button>
                    </form>

                </div>

            </section>

            <section id="right-cards" aria-label="Right Cards Section">
                <article class="daily-sales-card" aria-labelledby="daily-sales-title daily-sales-date daily-sales-value">
                    <h4 id="daily-sales-title" class="tittle-quiz">Mental Health</h4>
                    <div class="suggestion-div">
                        <h2>Suggestions</h2>
                        <p>
                            Your journey towards better mental health starts here. Take the quiz to unlock personalized mood analysis and meditation tips!
                        </p>
                        <div id="result" class="hidden result">
                            <div>
                                <h2>Your Mood Analysis</h2>
                                <p id="moodAnalysis">None</p>
                            </div>
                            <div>
                                <h2>Suggested Meditation</h2>
                                <p id="meditationSuggestion">None</p>
                                <div class="quiz-button-div">
                                    <button onclick="openModal()">
                                        Start Your Quiz
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </article>
                <div>
                    <div class="quote-card">
                        <h2>Quote Of The Day!</h2>
                        <blockquote>
                            “<?= htmlspecialchars($quote['quote_text']) ?>”
                        </blockquote>
                        <cite>— <?= htmlspecialchars($quote['quote_author']) ?></cite>
                    </div>
                </div>
            </section>

        </div>
    </main>

    <!-- quiz modal -->
    <div class="quiz-modal" id="quiz-modal">
        <div class="quiz-modal-card">
            <div class="cross-icon" onclick="closeModal()">
                <i class="fas fa-xmark"></i>
            </div>
            <h1>Mental Health Self-Assessment Quiz</h1>
            <form id="quizForm">
                <div id="questionsContainer" class="question-container">
                    <!-- Questions will be dynamically generated here -->
                </div>
                <button type="submit">Submit Quiz</button>
            </form>

        </div>
    </div>
    <!--end of quiz modal -->

    <!-- Bootstrap and JQuery scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>

    <script>
        // Sidebar submenu toggle
        document.querySelectorAll('.submenu-toggle').forEach(toggle => {
            toggle.addEventListener('click', () => {
                const submenu = toggle.nextElementSibling;
                const arrow = toggle.querySelector('.menu-arrow');

                if (submenu.classList.contains('open')) {
                    submenu.classList.remove('open');
                    arrow.classList.remove('rotate');
                } else {
                    submenu.classList.add('open');
                    arrow.classList.add('rotate');
                }
            });
        });

        // Optional: Sidebar collapse on small screen
        function checkWindowSize() {
            const sidebar = document.getElementById('sidebar');
            if (window.innerWidth < 576) {
                sidebar.classList.add('collapsed');
            } else {
                sidebar.classList.remove('collapsed');
            }
        }
        window.addEventListener('resize', checkWindowSize);
        window.addEventListener('load', checkWindowSize);
    </script>

    <script>
        let moodChart;

        // Navigation functions
        function closeNav() {
            document.getElementById("mobile-nav").classList.remove("active");
        }

        function openNav() {
            document.getElementById("mobile-nav").classList.add("active");
        }

        // Modal functions
        function openModal() {
            document.getElementById("quiz-modal").style.display = "flex";
            loadQuiz();
        }

        function closeModal() {
            document.getElementById("quiz-modal").style.display = "none";
            resetQuiz();
        }

        // Update mood history
        function updateMoodHistory() {
            const moodButton = document.getElementById("mood-button");
            const moods = JSON.parse(localStorage.getItem("moodTracker")) || [];

            if (moods.length > 0) {
                // Get the latest mood entry
                const latestEntry = moods[moods.length - 1];
                moodButton.textContent = `Mood: ${latestEntry.mood}`;
                moodButton.setAttribute('aria-label', `Mood ${latestEntry.mood} Button`);
            } else {
                // Default text if no moods tracked yet
                moodButton.textContent = "Mood: None";
                moodButton.setAttribute('aria-label', "Mood None Button");
            }
        }


        // Chart update using Chart.js
        function updateChart() {
            const ctx = document.getElementById("mood-chart").getContext("2d");
            const moods = JSON.parse(localStorage.getItem("moodTracker")) || [];

            const moodCounts = moods.reduce((acc, {
                mood
            }) => {
                acc[mood] = (acc[mood] || 0) + 1;
                return acc;
            }, {});

            const labels = Object.keys(moodCounts);
            const data = Object.values(moodCounts);

            if (moodChart) {
                moodChart.data.labels = labels;
                moodChart.data.datasets[0].data = data;
                moodChart.update();
            } else {
                moodChart = new Chart(ctx, {
                    type: "bar",
                    data: {
                        labels: labels,
                        datasets: [{
                            label: "Mood Frequency",
                            data: data,
                            backgroundColor: [
                                "#4CAF50", "#FF5733", "#FFC300",
                                "#33C3FF", "#FF33C4", "#33FF57"
                            ],
                            borderWidth: 1
                        }]
                    },
                    options: {
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        }
                    }
                });
            }
        }

        // Quiz load function
        function loadQuiz() {
            const questions = [
                "How often do you feel overwhelmed by daily tasks?",
                "How often do you have trouble sleeping?",
                "Do you feel anxious without any specific reason?",
                "Do you often feel down or hopeless?",
                "How often do you struggle to enjoy activities you used to like?",
                "Do you find it hard to focus on work or studies?",
                "How often do you feel isolated or lonely?",
                "Do you get easily irritated or angry?",
                "How often do you feel tired or have low energy?",
                "Do you worry about your health frequently?",
                "How often do you avoid social situations?",
                "Do you experience sudden mood changes?",
                "How often do you feel restless or unable to relax?",
                "Do you struggle with low self-esteem?",
                "How often do you feel nervous or on edge?",
                "Do you have difficulty managing your stress levels?",
                "How often do you feel like crying without any particular reason?",
                "Do you experience frequent headaches or physical tension?",
                "How often do you feel guilty or blame yourself?",
                "Do you feel disconnected from reality at times?",
                "How often do you feel out of control with your emotions?",
                "Do you find it hard to make decisions?",
                "How often do you engage in negative self-talk?",
                "Do you feel like your mind is racing with thoughts?",
                "How often do you feel unmotivated or apathetic?",
            ];

            function getRandomQuestions(questions) {
                return questions.sort(() => 0.5 - Math.random()).slice(0, 10);
            }

            const randomQuestions = getRandomQuestions(questions);
            const questionsContainer = document.getElementById("questionsContainer");
            questionsContainer.innerHTML = "";

            randomQuestions.forEach((question, index) => {
                const questionDiv = document.createElement("div");
                questionDiv.classList.add("question");
                questionDiv.innerHTML = `
            <p>${index + 1}. ${question}</p>
            <label><input type="radio" name="q${index + 1}" value="1"> Rarely</label>
            <label><input type="radio" name="q${index + 1}" value="2"> Sometimes</label>
            <label><input type="radio" name="q${index + 1}" value="3"> Often</label>
            <label><input type="radio" name="q${index + 1}" value="4"> Always</label>
        `;
                questionsContainer.appendChild(questionDiv);
            });

            document.getElementById("quizForm").addEventListener("submit", function(event) {
                event.preventDefault();
                let score = 0;

                for (let i = 1; i <= 10; i++) {
                    const selectedOption = document.querySelector(`input[name="q${i}"]:checked`);
                    if (selectedOption) {
                        score += parseInt(selectedOption.value);
                    }
                }

                displayResult(score);
                closeModal();
            });
        }



        
        // Display quiz result and update mood
        function displayResult(score) {
            const result = document.getElementById("result");
            const moodAnalysis = document.getElementById("moodAnalysis");
            const meditationSuggestion = document.getElementById("meditationSuggestion");
            const moods = JSON.parse(localStorage.getItem("moodTracker")) || [];

            const now = new Date();
            const date = now.toLocaleDateString();
            const time = now.toLocaleTimeString();

            let mood = "";
            if (score <= 10) {
                mood = "Happy";
                moodAnalysis.textContent = "You are in a positive mood.";
                meditationSuggestion.textContent = "Gratitude Meditation: Reflect on things you're grateful for.";
            } else if (score <= 15) {
                mood = "Anxious";
                moodAnalysis.textContent = "Your mood is generally good.";
                meditationSuggestion.textContent = "Breathing Exercise: Deep, slow breaths to relax.";
            } else if (score <= 20) {
                mood = "Excited";
                moodAnalysis.textContent = "You might be experiencing mild stress.";
                meditationSuggestion.textContent = "Mindful Breathing: Focus on your breath to reduce stress.";
            } else if (score <= 25) {
                mood = "Relaxed";
                moodAnalysis.textContent = "You seem to be feeling anxious or stressed.";
                meditationSuggestion.textContent = "Body Scan: Relax each body part to release tension.";
            } else if (score <= 30) {
                mood = "Angry";
                moodAnalysis.textContent = "You likely have high stress or anxiety.";
                meditationSuggestion.textContent = "Guided Visualization: Imagine a peaceful place.";
            } else {
                mood = "Sad";
                moodAnalysis.textContent = "You appear under significant emotional distress.";
                meditationSuggestion.textContent = "Guided Anxiety Relief: Follow a guided session.";
            }

            moods.push({
                date,
                time,
                mood
            });
            localStorage.setItem("moodTracker", JSON.stringify(moods));

            updateMoodHistory();
            updateChart();

            result.classList.remove("hidden");
        }

        // Reset the quiz
        function resetQuiz() {
            document.getElementById("quizForm").reset();
            document.getElementById("result").classList.add("hidden");
        }

        // DOM Content Loaded Initialization
        document.addEventListener("DOMContentLoaded", () => {
            const form = document.getElementById("mood-form");
            const moodSelect = document.getElementById("mood");

            const moods = JSON.parse(localStorage.getItem("moodTracker")) || [];

            form.addEventListener("submit", (e) => {
                e.preventDefault();
                const mood = moodSelect.value;
                if (!mood) return;

                const now = new Date();
                const date = now.toLocaleDateString();
                const time = now.toLocaleTimeString();

                moods.push({
                    date,
                    time,
                    mood
                });
                localStorage.setItem("moodTracker", JSON.stringify(moods));
                updateMoodHistory();
                updateChart();
                moodSelect.value = "";
            });

            updateMoodHistory();
            updateChart();

            // Random items in video/article/podcast sections
            function getRandomItems(container, count) {
                const items = Array.from(container.querySelectorAll(".card"));
                const shuffled = items.sort(() => 0.5 - Math.random()).slice(0, count);
                container.innerHTML = "";
                shuffled.forEach(item => container.appendChild(item));
            }

            const videoContainer = document.querySelector('.videos-container .container');
            const articleContainer = document.querySelector('.article-container .container');
            const podcastContainer = document.querySelector('.podcast-container .container');

            if (videoContainer && articleContainer && podcastContainer) {
                getRandomItems(videoContainer, 3);
                getRandomItems(articleContainer, 3);
                getRandomItems(podcastContainer, 3);
            }
        });
    </script>

<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/68086a31803f261911f99216/1ipgdtkrc';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->

</body>

</html>